/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.shape;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.geoviewer.GeographicalAction;
import nl.cloudfarming.client.geoviewer.Geometrical;
import nl.cloudfarming.client.model.Bean;
import nl.cloudfarming.client.util.GeometryUtil;
import org.openide.util.NbBundle;

public class Shape
extends Bean
implements Geometrical<Geometry, Shape> {
    private static long lastId = 0L;
    private Geometry geometry;
    private String name;
    private final long id;
    private ShapeType type;

    public Shape() {
        this.id = lastId++;
    }

    public Shape(String wkt) throws ParseException {
        this.geometry = GeometryUtil.wktToGeometry((String)wkt);
        this.id = lastId++;
    }

    public Shape(Geometry geometry) {
        this.geometry = geometry;
        this.id = lastId++;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getPropertyChangeSupport().firePropertyChange("name", old, name);
        this.fireUndoableEvent("name", this, old, name);
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public Shape getObject() {
        return this;
    }

    public String getKey() {
        return this.getName();
    }

    public Object getKeyAttributeValue() {
        return this.getName();
    }

    public String getTooltipText() {
        return this.getName();
    }

    public long getId() {
        return this.id;
    }

    public GeographicalAction[] getActions() {
        return null;
    }

    public ShapeType getType() {
        return this.type;
    }

    public void setType(ShapeType type) {
        ShapeType old = this.type;
        this.type = type;
        this.getPropertyChangeSupport().firePropertyChange("type", (Object)old, (Object)type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Shape other = (Shape)((Object)obj);
        if (!(this.geometry == other.geometry || this.geometry != null && this.geometry.equals(other.geometry))) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 79 * hash + (this.geometry != null ? this.geometry.hashCode() : 0);
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 79 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 79 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }

    public Geometry getRenderObject(Envelope envelope) {
        if (envelope.intersects(this.geometry.getEnvelopeInternal())) {
            return this.geometry;
        }
        return null;
    }

    public Point getCentroid() {
        return this.geometry.getCentroid();
    }

    public static enum ShapeType {
        SKIP,
        FIELD,
        HELPLINE;


        public String toString() {
            return NbBundle.getMessage(AreaFieldModule.class, (String)("shapetype." + this.name().toLowerCase()));
        }
    }

    public static class Builder {
        private Shape shape = new Shape();

        public Builder setName(String name) {
            this.shape.setName(name);
            return this;
        }

        public Builder setType(ShapeType type) {
            this.shape.setType(type);
            return this;
        }

        public Shape build() {
            return this.shape;
        }
    }
}

