/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.RollbackException;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import nl.cloudfarming.client.area.AreaEvent;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.AreaFieldModule;
import nl.cloudfarming.client.area.field.FieldAreaService;
import nl.cloudfarming.client.area.field.LineAction;
import nl.cloudfarming.client.logging.AppLogFactory;
import nl.cloudfarming.client.logging.AppLogger;
import nl.cloudfarming.client.model.HelpLine;
import nl.cloudfarming.eventbus.BaseGuiEventProducer;
import nl.cloudfarming.eventbus.GuiEventKey;
import org.jdesktop.swingx.JXPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RemoveHelpLineAction
extends LineAction {
    private static final String ACTION_NAME = NbBundle.getMessage(AreaFieldModule.class, (String)"action.remove_line.name");
    private static final String BUTTON_OK = NbBundle.getMessage(AreaFieldModule.class, (String)"action.remove_line.dialog.button.ok.text");
    private static final String BUTTON_CANCEL = NbBundle.getMessage(AreaFieldModule.class, (String)"action.remove_line.dialog.button.cancel.text");
    private static final String DIALOG_DISPLAY_NAME = NbBundle.getMessage(AreaFieldModule.class, (String)"action.remove_line.dialog.display_name");
    private static final String CASCADE_MESSAGE = NbBundle.getMessage(AreaFieldModule.class, (String)"action.remove_line.dialog.cascade_error_message");
    private Dialog dlg;
    private final HelpLine line;
    private AreaService service;
    private final EventProducer eventProducer = new EventProducer();
    private static final AppLogger LOG = AppLogFactory.getLogger(AreaFieldModule.class);

    public RemoveHelpLineAction() {
        super(ACTION_NAME);
        this.line = (HelpLine)Utilities.actionsGlobalContext().lookup(HelpLine.class);
        this.service = this.getService();
    }

    public void actionPerformed(ActionEvent e) {
        JXPanel panel = new JXPanel((LayoutManager)new MigLayout("wrap 2"));
        String confirmationText = NbBundle.getMessage(AreaFieldModule.class, (String)"action.remove_line.dialog.confirmation_text", (Object)this.line.getName());
        panel.add((Component)new JLabel(confirmationText));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, DIALOG_DISPLAY_NAME);
        dd.setOptions(new Object[]{this.getOkButton(), this.getCancelButton()});
        this.dlg = DialogDisplayer.getDefault().createDialog(dd);
        this.dlg.setVisible(true);
    }

    private JButton getOkButton() {
        JButton jButtonOK = new JButton();
        jButtonOK.setText(BUTTON_OK);
        jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    RemoveHelpLineAction.this.service.removeHelpLine(RemoveHelpLineAction.this.line);
                }
                catch (RollbackException ex) {
                    LOG.info(CASCADE_MESSAGE);
                }
                RemoveHelpLineAction.this.eventProducer.triggerEvent((GuiEventKey)AreaEvent.HELP_LINE_REMOVED);
            }
        });
        return jButtonOK;
    }

    private JButton getCancelButton() {
        JButton jButtonCancel = new JButton();
        jButtonCancel.setText(BUTTON_CANCEL);
        jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RemoveHelpLineAction.this.dlg.setVisible(false);
                RemoveHelpLineAction.this.dlg = null;
            }
        });
        return jButtonCancel;
    }

    private AreaService getService() {
        return this.service == null ? (this.service = (AreaService)Lookup.getDefault().lookup(AreaService.class)) : this.service;
    }

    public void setService(FieldAreaService service) {
        this.service = service;
    }

    private class EventProducer
    extends BaseGuiEventProducer {
        public EventProducer() {
            super(AreaEvent.class);
        }
    }
}

