/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.FieldAction;
import nl.cloudfarming.client.geoviewer.GeographicalAction;
import nl.cloudfarming.client.geoviewer.Geometrical;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.client.util.GeometryUtil;
import org.openide.util.Lookup;

public class FieldLayerObject
implements Geometrical<MultiPolygon, Field> {
    private final MultiPolygon geometry;
    private final Field field;
    private AreaService service;
    private static final Logger LOG = Logger.getLogger("FieldLayerObject.Actions");

    public FieldLayerObject(Field field) throws IntrospectionException {
        this.field = field;
        this.geometry = (MultiPolygon)GeometryUtil.wktToGeometry((String)this.field.getWKT());
        this.service = this.getPlotAreaService();
    }

    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    public Field getObject() {
        return this.field;
    }

    public String getKey() {
        return Long.toString(this.field.getId());
    }

    public Long getKeyAttributeValue() {
        return this.field.getId();
    }

    public String getTooltipText() {
        return Long.toString(this.field.getId()) + " " + this.field.getName();
    }

    public long getId() {
        return this.field.getId();
    }

    public GeographicalAction[] getActions() {
        ArrayList layerObjectActions = new ArrayList();
        for (FieldAction fieldAction : Lookup.getDefault().lookupAll(FieldAction.class)) {
            try {
                layerObjectActions.add(((Object)((Object)fieldAction)).getClass().newInstance());
            }
            catch (InstantiationException ex) {
                LOG.log(Level.FINE, "Instantiation of new {0} failed", ((Object)((Object)fieldAction)).getClass());
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.FINE, "Instantiation of new {0} failed", ((Object)((Object)fieldAction)).getClass());
            }
        }
        return layerObjectActions.toArray(new GeographicalAction[0]);
    }

    protected final AreaService getPlotAreaService() {
        return this.service == null ? (AreaService)Lookup.getDefault().lookup(AreaService.class) : this.service;
    }

    protected void setPlotAreaService(AreaService service) {
        this.service = service;
    }

    public MultiPolygon getRenderObject(Envelope envelope) {
        if (envelope.intersects(this.geometry.getEnvelopeInternal())) {
            return this.geometry;
        }
        return null;
    }

    public Point getCentroid() {
        return this.geometry.getCentroid();
    }
}

