/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field.explorer;

import java.beans.IntrospectionException;
import java.util.List;
import nl.cloudfarming.client.area.AreaEventKey;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.FieldLayer;
import nl.cloudfarming.client.area.field.FieldLayerObject;
import nl.cloudfarming.client.area.field.explorer.FieldNode;
import nl.cloudfarming.client.geoviewer.Layer;
import nl.cloudfarming.client.model.Field;
import nl.cloudfarming.eventbus.GuiEvent;
import nl.cloudfarming.eventbus.GuiEventBus;
import nl.cloudfarming.eventbus.GuiEventKey;
import nl.cloudfarming.eventbus.GuiEventListener;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class FieldNodeFactory
extends ChildFactory<Field> {
    private AreaService service;
    private final FieldLayer layer;

    public FieldNodeFactory(FieldLayer layer) {
        this.layer = layer;
        GuiEventBus.addListener((GuiEventListener)new GuiEventListener(){

            public void onEvent(GuiEvent event) {
                FieldNodeFactory.this.refresh(true);
            }

            public boolean listensTo(GuiEventKey guiEventKey) {
                return guiEventKey.equals(AreaEventKey.IMPORT_SAVED) || guiEventKey.equals(AreaEventKey.FIELD_REMOVED);
            }

            public String getModuleName() {
                return "area-field";
            }
        });
    }

    protected Node createNodeForKey(Field key) {
        try {
            FieldLayerObject layerObject = new FieldLayerObject(key);
            this.layer.addObject(layerObject);
            return new FieldNode((Layer)this.layer, layerObject);
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected boolean createKeys(List<Field> toPopulate) {
        toPopulate.addAll(this.getService().findAllActiveFields());
        return true;
    }

    public AreaService getService() {
        if (this.service == null) {
            this.service = (AreaService)Lookup.getDefault().lookup(AreaService.class);
        }
        return this.service;
    }

    public void setService(AreaService service) {
        this.service = service;
    }
}

