/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.MultiLineString;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.cloudfarming.client.area.AreaService;
import nl.cloudfarming.client.area.field.LineAction;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.LayerObjectAction;
import nl.cloudfarming.client.model.HelpLine;
import nl.cloudfarming.client.util.GeometryUtil;
import org.openide.util.Lookup;

public class HelpLineLayerObject
implements LayerObject<MultiLineString, HelpLine> {
    private final MultiLineString geometry;
    private final HelpLine helpLine;
    private AreaService service;
    private static final Logger LOG = Logger.getLogger("LineLayerObject.Actions");

    public HelpLineLayerObject(HelpLine helpLine) throws IntrospectionException {
        this.helpLine = helpLine;
        this.geometry = (MultiLineString)GeometryUtil.wktToGeometry((String)helpLine.getWKT());
        this.service = this.getPlotAreaService();
    }

    public MultiLineString getGeometry() {
        return this.geometry;
    }

    public HelpLine getObject() {
        return this.helpLine;
    }

    public String getKey() {
        return Long.toString(this.helpLine.getId());
    }

    public Long getKeyAttributeValue() {
        return this.helpLine.getId();
    }

    public String getTooltipText() {
        return Long.toString(this.helpLine.getId()) + " " + this.helpLine.getName();
    }

    public long getId() {
        return this.helpLine.getId();
    }

    public void save() {
    }

    public LayerObjectAction[] getActions() {
        ArrayList layerObjectActions = new ArrayList();
        for (LineAction lineAction : Lookup.getDefault().lookupAll(LineAction.class)) {
            try {
                layerObjectActions.add(((Object)((Object)lineAction)).getClass().newInstance());
            }
            catch (InstantiationException ex) {
                LOG.log(Level.FINE, "Instantiation of new {0} failed", ((Object)((Object)lineAction)).getClass());
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.FINE, "Instantiation of new {0} failed", ((Object)((Object)lineAction)).getClass());
            }
        }
        return layerObjectActions.toArray(new LayerObjectAction[0]);
    }

    protected final AreaService getPlotAreaService() {
        return this.service == null ? (AreaService)Lookup.getDefault().lookup(AreaService.class) : this.service;
    }

    protected void setPlotAreaService(AreaService service) {
        this.service = service;
    }
}

