/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.StatePalette;
import nl.cloudfarming.client.model.PartField;
import nl.cloudfarming.client.model.Race;
import org.netbeans.api.visual.model.ObjectState;

public class PartFieldPalette
extends StatePalette {
    private final Color colorSelected = Color.RED;
    private final Color colorHoovered = Color.BLUE;
    private static final String OBJECT_NAME = "partField";
    private static HashMap<Race, Color> raceColorMap;
    private static ArrayList<Color> availableColors;

    public PartFieldPalette() {
        availableColors.add(Color.YELLOW);
        availableColors.add(Color.RED);
        availableColors.add(Color.BLUE);
        availableColors.add(Color.GREEN);
        availableColors.add(Color.ORANGE);
        availableColors.add(Color.PINK);
        availableColors.add(Color.GRAY);
        availableColors.add(Color.CYAN);
        availableColors.add(Color.MAGENTA);
    }

    public Color getColorForState(ObjectState state, LayerObject layerObject) {
        if (state.isSelected()) {
            return this.colorSelected;
        }
        if (state.isHovered() || state.isObjectHovered()) {
            return this.colorHoovered;
        }
        return layerObject.getObjectColor();
    }

    public String getSensorName() {
        return OBJECT_NAME;
    }

    public Class forClass() {
        return PartField.class;
    }

    public List getPaletteOptions() {
        return Collections.EMPTY_LIST;
    }

    public static Color getColorForRace(Race race) {
        if (raceColorMap == null) {
            raceColorMap = new HashMap();
        }
        if (raceColorMap.containsKey(race)) {
            return raceColorMap.get(race);
        }
        if (!availableColors.isEmpty()) {
            Color returnColor = availableColors.get(0);
            availableColors.remove(returnColor);
            raceColorMap.put(race, returnColor);
            return returnColor;
        }
        return PartFieldPalette.getRandomColor(race);
    }

    private static Color getRandomColor(Race race) {
        Color returnColor = RandomColor.randomColor();
        for (Race mapRace : raceColorMap.keySet()) {
            if (!raceColorMap.get(mapRace).equals(returnColor)) continue;
            PartFieldPalette.getRandomColor(race);
            break;
        }
        return returnColor;
    }

    static {
        availableColors = new ArrayList();
    }

    private static class RandomColor {
        private static Random rand;

        public RandomColor() {
            rand = new Random();
        }

        public static Color randomColor() {
            return new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256));
        }
    }
}

