/*
 * Decompiled with CFR 0.152.
 */
package nl.cloudfarming.client.area.field;

import com.vividsolutions.jts.geom.MultiPolygon;
import java.awt.Color;
import nl.cloudfarming.client.area.field.PartFieldPalette;
import nl.cloudfarming.client.geoviewer.LayerObject;
import nl.cloudfarming.client.geoviewer.LayerObjectAction;
import nl.cloudfarming.client.model.PartField;
import nl.cloudfarming.client.util.GeometryUtil;

public class PartFieldLayerObject
implements LayerObject<MultiPolygon, PartField> {
    private final MultiPolygon geometry;
    private final PartField partField;

    public PartFieldLayerObject(PartField field) {
        this.partField = field;
        this.geometry = (MultiPolygon)GeometryUtil.wktToGeometry((String)field.getWKT());
    }

    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    public String getKey() {
        return Long.toString(this.partField.getId());
    }

    public String getTooltipText() {
        return Long.toString(this.partField.getId()) + " " + this.partField.getName();
    }

    public Long getKeyAttributeValue() {
        return this.partField.getId();
    }

    public long getId() {
        return this.partField.getId();
    }

    public PartField getObject() {
        return this.partField;
    }

    public LayerObjectAction[] getActions() {
        return null;
    }

    public void save() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Color getObjectColor() {
        return PartFieldPalette.getColorForRace(this.partField.getProductionUnit().getRace());
    }
}

