/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.utils;

import com.google.common.base.Charsets;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;

public class BinaryUtils {
    public static String readString(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray, Charsets.UTF_8);
    }

    public static ByteBuffer toByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static int readInt(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return byteBuffer.getInt(0);
    }

    public static void readFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        int n = fileChannel.read(byteBuffer);
        while (n != -1 && byteBuffer.position() != byteBuffer.capacity()) {
            n = fileChannel.read(byteBuffer);
        }
    }

    public static void readFully(FileChannel fileChannel, long l, ByteBuffer byteBuffer) throws IOException {
        int n = fileChannel.read(byteBuffer, l);
        while (n != -1 && byteBuffer.position() != byteBuffer.capacity()) {
            n = fileChannel.read(byteBuffer, l + (long)byteBuffer.position());
        }
    }

    public static void writeInt(FileChannel fileChannel, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer.position(0);
        int n2 = fileChannel.write(byteBuffer);
        while (n2 != -1 && byteBuffer.position() != byteBuffer.capacity()) {
            fileChannel.write(byteBuffer);
        }
    }

    public static void writeFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        int n = fileChannel.write(byteBuffer);
        while (n != -1 && byteBuffer.position() != byteBuffer.capacity()) {
            n = fileChannel.write(byteBuffer);
        }
    }

    public static int putString(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        return byArray.length + 4;
    }

    public static int putStringShort(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
        return byArray.length + 2;
    }

    public static int putStringWithoutSize(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.put(byArray);
        return byArray.length;
    }

    public static long getLong(FileChannel fileChannel, long l) throws IOException {
        fileChannel.position(l);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return byteBuffer.getLong(0);
    }

    public static long getLong(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return byteBuffer.getLong(0);
    }

    public static int getInt(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return byteBuffer.getInt(0);
    }

    public static int readInt(FileChannel fileChannel, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        fileChannel.position(n);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return byteBuffer.getInt(0);
    }

    public static void writeXBytes(ByteBuffer byteBuffer, int n, byte by) {
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            byteBuffer.put(UnsignedBytes.checkedCast((long)(n >> by2 * 8 & 0xFF)));
        }
    }

    public static void writeXBytes(byte[] byArray, int n, int n2, byte by) {
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            byArray[n + by2] = UnsignedBytes.checkedCast((long)(n2 >> by2 * 8 & 0xFF));
        }
    }

    public static void putUuid(UUID uUID, ByteBuffer byteBuffer) {
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
    }

    public static UUID getUuid(ByteBuffer byteBuffer) {
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
    }

    public static int putStringWithoutSize(int n, ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuffer.position(n);
        byteBuffer.put(byArray);
        return byArray.length;
    }

    public static ByteBuffer copyDirectBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.capacity()).order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        byteBuffer2.put(byArray);
        byteBuffer2.position(0);
        return byteBuffer2;
    }

    public static long writeFully(ByteBuffer byteBuffer, Path path) throws IOException {
        byteBuffer.position(0);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileChannel.write(byteBuffer);
        }
        return byteBuffer.capacity();
    }

    public static void writeString(FileChannel fileChannel, String string) throws IOException {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        int n = fileChannel.write(byteBuffer);
        while (n != -1 && byteBuffer.position() != byteBuffer.capacity()) {
            fileChannel.write(byteBuffer);
        }
    }

    public static String readString(FileChannel fileChannel) throws IOException {
        int n = BinaryUtils.readInt(fileChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        BinaryUtils.readFully(fileChannel, byteBuffer);
        return new String(byteBuffer.array(), Charsets.UTF_8);
    }
}

