/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.NewStreamDescriptor;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.StreamDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
extends JsonUpdate {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER;
    private ObjectNode errorNode;
    private JsonNode output;
    private Set<StreamDescriptor> attachedStreams;
    private Set<NewStreamDescriptor> attachedNewStreams;
    private boolean debug;
    public static final Response EMPTY;

    public Response() {
        super((String)null);
    }

    public Response(ErrorCode errorCode, Throwable throwable) {
        this(errorCode);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        this.errorNode.put("stacktrace", stringWriter.toString());
        this.errorNode.put("message", throwable.getMessage());
    }

    public Response(ErrorCode errorCode) {
        super((String)null);
        this.errorNode = Response.createObject();
        this.errorNode.put("code", errorCode.getCode());
        this.errorNode.put("type", errorCode.toString());
        this.errorNode.put("domain_full", errorCode.getClass().getName());
        this.errorNode.put("domain", errorCode.getClass().getSimpleName());
        this.errorNode.put("message", errorCode.getMessage());
        this.output = null;
    }

    public Response(ObjectNode objectNode) {
        super((String)null);
        this.setId(objectNode.get("id").asText());
        if (objectNode.has("error")) {
            this.setError(objectNode.get("error"));
        }
        this.setOutput(objectNode.get("output"));
    }

    public Response(byte[] byArray) {
        super(byArray);
    }

    public Response(String string, ArrayNode arrayNode) {
        super(string);
        this.output = arrayNode;
    }

    public Response(ErrorCode errorCode, String string) {
        this(errorCode);
        this.errorNode.put("userSafeMessage", string);
    }

    public Response(String string) {
        super(string);
    }

    public ObjectNode getErrorNode() {
        return this.errorNode;
    }

    public boolean hasError() {
        return this.errorNode != null;
    }

    public static Response createArrayResponse() {
        ArrayNode arrayNode = new ObjectMapper().createArrayNode();
        return new Response((String)null, arrayNode);
    }

    @Override
    public ObjectNode toJson() {
        ArrayNode arrayNode;
        ObjectNode objectNode = super.toJson();
        if (this.errorNode != null) {
            objectNode.set("error", (JsonNode)this.errorNode);
        }
        if (this.output != null) {
            objectNode.set("output", this.output);
        } else {
            objectNode.set("output", (JsonNode)NullNode.getInstance());
        }
        if (this.attachedStreams != null && !this.attachedStreams.isEmpty()) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (StreamDescriptor object : this.attachedStreams) {
                arrayNode.add((JsonNode)object.toJson());
            }
            objectNode.set("streams", (JsonNode)arrayNode);
        }
        if (this.attachedNewStreams != null && !this.attachedNewStreams.isEmpty()) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (NewStreamDescriptor newStreamDescriptor : this.attachedNewStreams) {
                arrayNode.add((JsonNode)OBJECT_MAPPER.convertValue((Object)newStreamDescriptor, ObjectNode.class));
            }
            objectNode.set("newstreams", (JsonNode)arrayNode);
        }
        if (this.debug) {
            objectNode.put("debug", true);
        }
        return objectNode;
    }

    public ErrorCode getErrorCode(ClassLoader classLoader) {
        if (this.errorNode == null) {
            return null;
        }
        try {
            Class<?> clazz = classLoader.loadClass(this.errorNode.get("domain_full").asText());
            if (clazz.isEnum()) {
                return (ErrorCode)Enum.valueOf(clazz, this.errorNode.get("type").asText());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("", (Throwable)classNotFoundException);
        }
        return null;
    }

    @Override
    public byte[] toMessageBytes() {
        ObjectNode objectNode = this.toJson();
        StringWriter stringWriter = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)stringWriter, (Object)objectNode);
            return stringWriter.toString().getBytes(Charsets.UTF_8);
        }
        catch (JsonGenerationException jsonGenerationException) {
            LOGGER.error("", (Throwable)jsonGenerationException);
        }
        catch (JsonMappingException jsonMappingException) {
            LOGGER.error("", (Throwable)jsonMappingException);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
        return null;
    }

    public JsonNode getOutput() {
        if (this.output == null) {
            this.output = Response.createObject();
        } else {
            if (this.output instanceof NullNode) {
                return null;
            }
            if (this.output instanceof BooleanNode) {
                return this.output;
            }
        }
        return this.output;
    }

    public static Response newNullResponse() {
        Response response = new Response();
        response.output = NullNode.getInstance();
        return response;
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.RESPONSE;
    }

    public void set(String string, JsonNode jsonNode) {
        if (this.output == null) {
            this.output = Response.createObject();
        }
        ((ObjectNode)this.output).set(string, jsonNode);
    }

    public void put(String string, boolean bl) {
        if (this.output == null) {
            this.output = Response.createObject();
        }
        ((ObjectNode)this.output).put(string, bl);
    }

    public void put(String string, int n) {
        if (this.output == null) {
            this.output = Response.createObject();
        }
        ((ObjectNode)this.output).put(string, n);
    }

    public void put(String string, String string2) {
        if (this.output == null) {
            this.output = Response.createObject();
        }
        ((ObjectNode)this.output).put(string, string2);
    }

    public static Response newObjectResponse() {
        Response response = new Response();
        response.output = OBJECT_MAPPER.createObjectNode();
        return response;
    }

    public boolean hasErrorCode() {
        return this.errorNode != null;
    }

    public static ObjectNode createObject() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        this.add((JsonNode)objectNode);
        return objectNode;
    }

    public void add(JsonNode jsonNode) {
        if (this.output == null) {
            this.output = Response.createArray();
        }
        if (!(this.output instanceof ArrayNode)) {
            throw new RuntimeException("No array");
        }
        ((ArrayNode)this.output).add(jsonNode);
    }

    public static ArrayNode createArray() {
        return OBJECT_MAPPER.createArrayNode();
    }

    public ArrayNode getArrayOutput() {
        if (this.output == null) {
            this.output = Response.createArray();
        }
        return (ArrayNode)this.output;
    }

    public void setOutput(JsonNode jsonNode) {
        this.output = jsonNode;
    }

    public void setOutput(List<Number> list) {
        for (Number number : list) {
            if (!(number instanceof Long)) continue;
            ((ArrayNode)this.output).add((Long)number);
        }
    }

    public String toString() {
        return this.toJson().toString();
    }

    public ObjectNode getObjectOutput() {
        return (ObjectNode)this.getOutput();
    }

    public void setError(JsonNode jsonNode) {
        this.errorNode = (ObjectNode)jsonNode;
    }

    @Override
    public void setData(ObjectNode objectNode) {
        ArrayNode arrayNode;
        if (objectNode.has("output")) {
            this.output = objectNode.get("output");
        }
        if (objectNode.has("error")) {
            this.errorNode = (ObjectNode)objectNode.get("error");
        }
        if (objectNode.has("streams")) {
            this.attachedStreams = new HashSet<StreamDescriptor>();
            arrayNode = (ArrayNode)objectNode.get("streams");
            for (JsonNode jsonNode : arrayNode) {
                this.attachedStreams.add(StreamDescriptor.fromJson((ObjectNode)jsonNode));
            }
        }
        if (objectNode.has("newstreams")) {
            this.attachedNewStreams = new HashSet<NewStreamDescriptor>();
            arrayNode = (ArrayNode)objectNode.get("newstreams");
            for (JsonNode jsonNode : arrayNode) {
                this.attachedNewStreams.add((NewStreamDescriptor)OBJECT_MAPPER.convertValue((Object)((ObjectNode)jsonNode), NewStreamDescriptor.class));
            }
        }
    }

    public Set<StreamDescriptor> getAttachedStreams() {
        return this.attachedStreams;
    }

    public Set<NewStreamDescriptor> getAttachedNewStreams() {
        return this.attachedNewStreams;
    }

    public Response addStream(StreamDescriptor streamDescriptor) {
        if (this.attachedStreams == null) {
            this.attachedStreams = new HashSet<StreamDescriptor>();
        }
        this.attachedStreams.add(streamDescriptor);
        return this;
    }

    public static Response newResponseByOutput(ObjectNode objectNode) {
        Response response = new Response();
        response.setOutput((JsonNode)objectNode);
        return response;
    }

    @Override
    public String getSubType() {
        return null;
    }

    public static Response fromBytes(byte[] byArray) {
        try {
            ObjectNode objectNode = (ObjectNode)new ObjectMapper().readValue(byArray, ObjectNode.class);
            if (objectNode.has("type")) {
                String string = objectNode.get("type").asText();
                if (string.equals("RESPONSE")) {
                    return new Response(byArray);
                }
                if (string.equals("ASYNC_RESPONSE")) {
                    return null;
                }
                throw new RuntimeException();
            }
        }
        catch (JsonParseException jsonParseException) {
            LOGGER.error("", (Throwable)jsonParseException);
            LOGGER.error(new String(byArray, Charsets.UTF_8));
        }
        catch (JsonMappingException jsonMappingException) {
            LOGGER.error(new String(byArray, Charsets.UTF_8));
            LOGGER.error(new String(byArray, Charsets.UTF_8), (Throwable)jsonMappingException);
        }
        catch (IOException iOException) {
            LOGGER.error(new String(byArray, Charsets.UTF_8));
            LOGGER.error("", (Throwable)iOException);
        }
        return null;
    }

    public static Response createBooleanResponse(boolean bl) {
        Response response = new Response();
        response.setOutput((JsonNode)BooleanNode.valueOf((boolean)bl));
        return response;
    }

    public static Response createLongResponse(long l) {
        Response response = new Response();
        response.setOutput((JsonNode)LongNode.valueOf((long)l));
        return response;
    }

    public void sortOutputArray(Comparator<JsonNode> comparator) {
        ArrayNode arrayNode = this.getArrayOutput();
        ArrayList<JsonNode> arrayList = new ArrayList<JsonNode>(arrayNode.size());
        for (JsonNode jsonNode : arrayNode) {
            arrayList.add(jsonNode);
        }
        arrayList.sort(comparator);
        this.output = new ArrayNode(OBJECT_MAPPER.getNodeFactory(), arrayList);
    }

    public static Response createStringResponse(String string) {
        Response response = new Response();
        response.setOutput((JsonNode)TextNode.valueOf((String)string));
        return response;
    }

    public static Response createObjectResponse(ObjectNode objectNode) {
        Response response = new Response();
        response.setOutput((JsonNode)objectNode);
        return response;
    }

    public static Response createResponse(JsonNode jsonNode) {
        Response response = new Response();
        response.setOutput(jsonNode);
        return response;
    }

    public static Response createObjectResponse() {
        Response response = new Response();
        response.output = OBJECT_MAPPER.createObjectNode();
        return response;
    }

    public void put(String string, long l) {
        if (this.output == null) {
            this.output = Response.createObject();
        }
        ((ObjectNode)this.output).put(string, l);
    }

    public static Response createErrorResponse(ErrorCode errorCode) {
        Response response = new Response(errorCode);
        return response;
    }

    public static Response createFloatResponse(float f) {
        Response response = new Response();
        response.setOutput((JsonNode)DoubleNode.valueOf((double)f));
        return response;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public static Response createErrorResponse(ErrorCode errorCode, String string) {
        Response response = new Response(errorCode, string);
        return response;
    }

    public static Response createArrayResponse(ArrayNode arrayNode) {
        Response response = new Response();
        response.setOutput((JsonNode)arrayNode);
        return response;
    }

    public void put(String string, double d) {
        this.getObjectOutput().put(string, d);
    }

    public static Response createStreamResponse(StreamDescriptor streamDescriptor) {
        Response response = new Response();
        response.addStream(streamDescriptor);
        return response;
    }

    public void setErrorPayload(JsonNode jsonNode) {
        this.errorNode.set("payload", jsonNode);
    }

    public static ObjectNode createError(ErrorCode errorCode, String string) {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("code", errorCode.getCode());
        objectNode.put("userSafeMessage", string);
        return objectNode;
    }

    public void add(double d) {
        ((ArrayNode)this.output).add(d);
    }

    public void add(String string) {
        ((ArrayNode)this.output).add(string);
    }

    public boolean hasStreams() {
        return this.attachedStreams != null && !this.attachedStreams.isEmpty();
    }

    public Response addNewStream(NewStreamDescriptor newStreamDescriptor) {
        if (this.attachedNewStreams == null) {
            this.attachedNewStreams = new HashSet<NewStreamDescriptor>();
        }
        this.attachedNewStreams.add(newStreamDescriptor);
        return this;
    }

    static {
        OBJECT_MAPPER.findAndRegisterModules();
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        LOGGER = LoggerFactory.getLogger(Response.class);
        EMPTY = null;
    }
}

