/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import nl.sascom.backplanepublic.common.Stream;
import nl.sascom.backplanepublic.common.StreamManager;
import nl.sascom.backplanepublic.common.StreamMetaData;
import nl.sascom.backplanepublic.common.StreamReadingByteSource;
import nl.sascom.backplanepublic.common.StreamSource;
import nl.sascom.backplanepublic.common.utils.Formatters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStream
implements Stream,
Closeable,
StreamSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketStream.class);
    private long start;
    private RandomAccessFile randomAccessFile;
    private volatile int writePosition = 0;
    private int lastWriteSequence = -1;
    private volatile int totalBytes;
    private volatile boolean writingDone;
    private Path path;
    private String key;
    private StreamMetaData streamMetaData;
    private final Set<CountDownLatch> latches = new HashSet<CountDownLatch>();

    public WebSocketStream(StreamManager streamManager, String string, StreamMetaData streamMetaData) {
        this.key = string;
        this.streamMetaData = streamMetaData;
        this.path = streamManager.getPath().resolve(this.getKey());
        try {
            this.randomAccessFile = new RandomAccessFile(this.path.toFile(), "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        this.start = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n, ByteBuffer byteBuffer, int n2, int n3) {
        try {
            if (n != this.lastWriteSequence + 1) {
                throw new IOException("Unexpected sequence ID (got " + n + ", expected " + (this.lastWriteSequence + 1) + ")");
            }
            WebSocketStream webSocketStream = this;
            synchronized (webSocketStream) {
                this.randomAccessFile.seek(this.writePosition);
                this.randomAccessFile.write(byteBuffer.array(), n2, n3);
                this.writePosition += n3;
                if (n3 > 0) {
                    Set<CountDownLatch> set = this.latches;
                    synchronized (set) {
                        for (CountDownLatch countDownLatch : this.latches) {
                            countDownLatch.countDown();
                        }
                    }
                }
            }
            ++this.lastWriteSequence;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public ByteSource getByteSource() {
        return new StreamReadingByteSource(this);
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writingDone(int n) throws IOException {
        this.totalBytes = this.writePosition;
        this.writingDone = true;
        long l = System.nanoTime();
        LOGGER.info("Writing done for " + this.getKey().substring(0, 10) + " (" + (l - this.start) / 1000000L + "ms, " + Formatters.byteCountToDisplaySize(this.totalBytes) + ")");
        WebSocketStream webSocketStream = this;
        synchronized (webSocketStream) {
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(this.path.toFile(), "r");
        }
        if (n != this.lastWriteSequence + 1) {
            throw new IOException("Unexpected sequence ID (got " + n + ", expected " + (this.lastWriteSequence + 1) + ")");
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public StreamMetaData getStreamMetaData() {
        return this.streamMetaData;
    }

    public void writeNull(int n) {
        ++this.lastWriteSequence;
    }

    @Override
    public int getWritePosition() {
        return this.writePosition;
    }

    @Override
    public boolean writingIsDone() {
        return this.writingDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWriteLatch(CountDownLatch countDownLatch) {
        Set<CountDownLatch> set = this.latches;
        synchronized (set) {
            this.latches.add(countDownLatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWriteLatch(CountDownLatch countDownLatch) {
        Set<CountDownLatch> set = this.latches;
        synchronized (set) {
            this.latches.remove(countDownLatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int n, byte[] byArray, int n2, int n3) throws IOException {
        WebSocketStream webSocketStream = this;
        synchronized (webSocketStream) {
            this.randomAccessFile.seek(n);
            return this.randomAccessFile.read(byArray, n2, n3);
        }
    }
}

