/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;

public class Qid
implements Comparable<Qid> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final UUID vid;
    private final int oid;

    private Qid(UUID uUID, int n) {
        this.vid = uUID;
        this.oid = n;
    }

    public UUID getVersionId() {
        return this.vid;
    }

    public int getOid() {
        return this.oid;
    }

    public String toString() {
        return this.vid + "-" + this.oid;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.oid;
        n = 31 * n + (this.vid == null ? 0 : this.vid.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Qid qid = (Qid)object;
        if (this.oid != qid.oid) {
            return false;
        }
        return !(this.vid == null ? qid.vid != null : !this.vid.equals(qid.vid));
    }

    @Override
    public int compareTo(Qid qid) {
        int n = this.vid.compareTo(qid.vid);
        if (n == 0) {
            return Integer.compare(this.oid, qid.oid);
        }
        return n;
    }

    public static Qid of(String string) {
        return new Qid(UUID.fromString(string.substring(0, string.lastIndexOf("-"))), Integer.parseInt(string.substring(string.lastIndexOf("-") + 1)));
    }

    public static Qid of(UUID uUID, int n) {
        return new Qid(uUID, n);
    }

    public JsonNode toJson() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("vid", this.vid.toString());
        objectNode.put("oid", this.oid);
        return objectNode;
    }

    public static Collection<Qid> of(UUID uUID, Set<Integer> set) {
        ArrayList<Qid> arrayList = new ArrayList<Qid>();
        for (int n : set) {
            arrayList.add(Qid.of(uUID, n));
        }
        return arrayList;
    }
}

