/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.common.HttpUploadStream;
import nl.sascom.backplanepublic.common.LocalStreamDescriptor;
import nl.sascom.backplanepublic.common.SafeWebSocketStream;
import nl.sascom.backplanepublic.common.SignedStreamDescriptor;
import nl.sascom.backplanepublic.common.Stream;
import nl.sascom.backplanepublic.common.StreamAlreadyRegisteredException;
import nl.sascom.backplanepublic.common.StreamBackupException;
import nl.sascom.backplanepublic.common.StreamDescriptor;
import nl.sascom.backplanepublic.common.StreamMetaData;
import nl.sascom.backplanepublic.common.StreamNotFoundException;
import nl.sascom.backplanepublic.common.WebSocketStream;
import nl.sascom.backplanepublic.common.WriteableStream;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamManager.class);
    private final Map<String, Stream> registeredStreams = Collections.synchronizedMap(new HashMap());
    private final Map<String, CountDownLatch> waiting = new HashMap<String, CountDownLatch>();
    private final Random random = new SecureRandom();
    private final Path path;

    public StreamManager(Path path) {
        this.path = path;
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                LOGGER.error("", (Throwable)iOException);
            }
        }
    }

    public Path getPath() {
        return this.path;
    }

    public StreamDescriptor registerStream(String string, ByteSource byteSource, StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        HttpUploadStream httpUploadStream = new HttpUploadStream(string, byteSource, streamMetaData);
        this.putStream(httpUploadStream);
        return new LocalStreamDescriptor(string);
    }

    public StreamDescriptor registerStream(String string, Path path, StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        HttpUploadStream httpUploadStream = new HttpUploadStream(string, path, streamMetaData);
        this.putStream(httpUploadStream);
        return new LocalStreamDescriptor(string);
    }

    public StreamDescriptor registerStream(Path path, StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        String string = this.generateKey();
        HttpUploadStream httpUploadStream = new HttpUploadStream(string, path, streamMetaData);
        this.putStream(httpUploadStream);
        return new LocalStreamDescriptor(string);
    }

    public void remove(String string) throws StreamNotFoundException {
        Stream stream = this.registeredStreams.get(string);
        if (stream == null) {
            throw new StreamNotFoundException("Stream with identifier " + string + " not found");
        }
        this.registeredStreams.remove(string);
    }

    public ByteSource getSource(String string) throws StreamNotFoundException {
        Stream stream = this.registeredStreams.get(string);
        if (stream != null) {
            return stream.getByteSource();
        }
        throw new StreamNotFoundException("Stream with identifier " + string + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteSource getSource(String string, long l, TimeUnit timeUnit) throws StreamNotFoundException, InterruptedException {
        Stream stream = this.registeredStreams.get(string);
        if (stream == null) {
            CountDownLatch countDownLatch = null;
            Map<String, CountDownLatch> map = this.waiting;
            synchronized (map) {
                if (this.waiting.containsKey(string)) {
                    countDownLatch = this.waiting.get(string);
                } else {
                    countDownLatch = new CountDownLatch(1);
                    this.waiting.put(string, countDownLatch);
                }
            }
            if (countDownLatch.await(l, timeUnit)) {
                return this.registeredStreams.get(string).getByteSource();
            }
            throw new StreamNotFoundException("Stream not found");
        }
        return stream.getByteSource();
    }

    public Stream getStream(String string) throws StreamNotFoundException {
        Stream stream = this.registeredStreams.get(string);
        if (stream != null) {
            return stream;
        }
        throw new StreamNotFoundException("Stream with identifier " + string + " not found");
    }

    public StreamDescriptor getLocalStreamDescriptor(String string) throws StreamNotFoundException {
        return new LocalStreamDescriptor(string);
    }

    public String registerStream(InputStream inputStream) throws StreamAlreadyRegisteredException {
        return this.registerStream(null, inputStream);
    }

    public String registerStream(String string, InputStream inputStream) throws StreamAlreadyRegisteredException {
        Object object;
        if (string == null) {
            string = this.generateKey();
        }
        if (this.registeredStreams.containsKey(string)) {
            throw new StreamAlreadyRegisteredException(string);
        }
        Path path = this.path.resolve(string);
        if (Files.exists(path, new LinkOption[0])) {
            throw new StreamAlreadyRegisteredException("File exists: " + path);
        }
        try {
            object = Files.newOutputStream(path, new OpenOption[0]);
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)bufferedOutputStream);
            }
            finally {
                if (object != null) {
                    ((OutputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
        object = new HttpUploadStream(string, com.google.common.io.Files.asByteSource((File)path.toFile()), null);
        this.putStream((Stream)object);
        return string;
    }

    public StreamDescriptor registerStream(ByteSource byteSource, StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        String string = this.generateKey();
        this.registerStream(string, byteSource, streamMetaData);
        return new LocalStreamDescriptor(string);
    }

    public WriteableStream createWriteableStream(StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        String string = this.generateKey();
        WriteableStream writeableStream = new WriteableStream(this, string, streamMetaData);
        this.putStream(writeableStream);
        return writeableStream;
    }

    private String generateKey() {
        byte[] byArray = new byte[64];
        this.random.nextBytes(byArray);
        String string = Hex.encodeHexString((byte[])byArray);
        return string;
    }

    public WebSocketStream getStreamWriter(String string) throws StreamAlreadyRegisteredException {
        if (this.registeredStreams.containsKey(string)) {
            Stream stream = this.registeredStreams.get(string);
            if (stream instanceof WebSocketStream) {
                return (WebSocketStream)stream;
            }
            return null;
        }
        WebSocketStream webSocketStream = new WebSocketStream(this, string, new StreamMetaData(null, null));
        this.putStream(webSocketStream);
        return webSocketStream;
    }

    public SafeWebSocketStream getSafeStreamWriter(String string) throws StreamNotFoundException {
        if (this.registeredStreams.containsKey(string)) {
            Stream stream = this.registeredStreams.get(string);
            if (stream instanceof SafeWebSocketStream) {
                return (SafeWebSocketStream)stream;
            }
            return null;
        }
        throw new StreamNotFoundException(string);
    }

    public boolean has(String string) {
        return this.registeredStreams.containsKey(string);
    }

    public SafeWebSocketStream createSafeStreamWriter(String string, StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        SafeWebSocketStream safeWebSocketStream = new SafeWebSocketStream(this, string, streamMetaData);
        this.putStream(safeWebSocketStream);
        return safeWebSocketStream;
    }

    public WebSocketStream createStreamWriter(String string, StreamMetaData streamMetaData) throws StreamAlreadyRegisteredException {
        WebSocketStream webSocketStream = new WebSocketStream(this, string, streamMetaData);
        this.putStream(webSocketStream);
        return webSocketStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStream(Stream stream) throws StreamAlreadyRegisteredException {
        if (this.registeredStreams.containsKey(stream.getKey())) {
            throw new StreamAlreadyRegisteredException(stream.getKey());
        }
        this.registeredStreams.put(stream.getKey(), stream);
        Map<String, CountDownLatch> map = this.waiting;
        synchronized (map) {
            CountDownLatch countDownLatch = this.waiting.get(stream.getKey());
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        }
    }

    public StreamDescriptor createSignedStream(Path path, LocalDateTime localDateTime, StreamMetaData streamMetaData) {
        String string = this.generateKey();
        return new SignedStreamDescriptor(string, path, localDateTime, streamMetaData);
    }

    public void backupStreamAsync(String string, String string2, int n, TimeUnit timeUnit) throws StreamBackupException {
        throw new UnsupportedOperationException("Not supported in non-Node configuration");
    }

    public StreamDescriptor getPrivateDownloadLink(String string, String string2, String string3, String string4) throws StreamBackupException {
        throw new UnsupportedOperationException("Not supported in non-Node configuration");
    }

    public void backupStreamSync(String string, String string2, int n, TimeUnit timeUnit) throws StreamBackupException {
        throw new UnsupportedOperationException("Not supported in non-Node configuration");
    }

    public ByteSource getSource(StreamDescriptor streamDescriptor) {
        return null;
    }
}

