/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import java.io.IOException;
import nl.sascom.backplanepublic.common.BinaryDataPush;
import nl.sascom.backplanepublic.common.DataPush;
import nl.sascom.backplanepublic.common.LogMessage;
import nl.sascom.backplanepublic.common.MetricDefinitionUpdate;
import nl.sascom.backplanepublic.common.MetricValueUpdate;
import nl.sascom.backplanepublic.common.Progress;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.StatusChange;
import nl.sascom.backplanepublic.common.TaskInfo;
import nl.sascom.backplanepublic.common.TaskStatus;
import nl.sascom.backplanepublic.common.UpdateInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonUpdate
implements UpdateInterface {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUpdate.class);
    private String id;

    public JsonUpdate(String string) {
        this.id = string;
    }

    public JsonUpdate(byte[] byArray) {
        try {
            ObjectNode objectNode = (ObjectNode)new ObjectMapper().readValue(byArray, ObjectNode.class);
            this.id = objectNode.get("id").asText();
            this.setData(objectNode);
        }
        catch (JsonParseException jsonParseException) {
            LOGGER.error("", (Throwable)jsonParseException);
        }
        catch (JsonMappingException jsonMappingException) {
            LOGGER.error("", (Throwable)jsonMappingException);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte[] toMessageBytes() {
        return this.toJson().toString().getBytes(Charsets.UTF_8);
    }

    public abstract void setData(ObjectNode var1);

    public ObjectNode toJson() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("id", this.id);
        objectNode.put("type", this.getResponseType().name());
        return objectNode;
    }

    @Override
    public abstract ResponseType getResponseType();

    public static UpdateInterface create(ObjectNode objectNode) {
        ResponseType responseType = ResponseType.valueOf(objectNode.get("type").asText());
        UpdateInterface updateInterface = null;
        switch (responseType) {
            case LOG: {
                updateInterface = new LogMessage(objectNode.get("id").asText(), objectNode.get("level").asText(), objectNode.get("message").asText());
                break;
            }
            case METRIC_UPDATE: {
                updateInterface = new MetricValueUpdate(objectNode.get("id").asText(), objectNode.get("path").asText(), objectNode.get("key").asText(), objectNode.get("value"));
                break;
            }
            case METRIC_DEFINITION_UPDATE: {
                updateInterface = MetricDefinitionUpdate.fromJson(objectNode.get("id").asText(), objectNode);
                break;
            }
            case PROGRESS: {
                updateInterface = new Progress(objectNode.get("id").asText(), objectNode.get("label").asText(), objectNode.get("progress").asInt());
                break;
            }
            case RESPONSE: {
                Response response = new Response(objectNode.get("id").asText());
                if (objectNode.has("output")) {
                    response.setOutput(objectNode.get("output"));
                }
                if (objectNode.has("error")) {
                    response.setError(objectNode.get("error"));
                }
                updateInterface = response;
                break;
            }
            case STATUS_CHANGE: {
                updateInterface = new StatusChange(objectNode.get("id").asText(), TaskStatus.valueOf(objectNode.get("oldStatus").asText()), TaskStatus.valueOf(objectNode.get("status").asText()));
                break;
            }
            case DATA_PUSH: {
                updateInterface = new DataPush(objectNode.get("id").asText(), objectNode.get("topicId").asText(), objectNode.get("data"));
                break;
            }
            case TASK_INFO: {
                updateInterface = new TaskInfo(objectNode.get("id").asText(), objectNode.get("data"));
                break;
            }
            case ASYNC_RESPONSE: {
                throw new RuntimeException("ASYNC_RESPONSE not implemented");
            }
            case BINARY_DATA_PUSH: {
                throw new RuntimeException("BINARY_DATA_PUSH not implemented");
            }
        }
        if (objectNode.has("debug") && objectNode.get("debug").asBoolean()) {
            updateInterface.setDebug(true);
        }
        return updateInterface;
    }

    public static UpdateInterface create(ResponseType responseType, byte[] byArray) {
        switch (responseType) {
            case LOG: {
                return new LogMessage(byArray);
            }
            case METRIC_UPDATE: {
                return new MetricValueUpdate(byArray);
            }
            case METRIC_DEFINITION_UPDATE: {
                return new MetricDefinitionUpdate(byArray);
            }
            case PROGRESS: {
                return new Progress(byArray);
            }
            case RESPONSE: {
                return new Response(byArray);
            }
            case STATUS_CHANGE: {
                return new StatusChange(byArray);
            }
            case DATA_PUSH: {
                return new DataPush(byArray);
            }
            case BINARY_DATA_PUSH: {
                return new BinaryDataPush(byArray);
            }
            case TASK_INFO: {
                return new TaskInfo(byArray);
            }
        }
        return null;
    }
}

