/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.GregorianCalendar;
import java.util.UUID;
import nl.sascom.backplanepublic.common.MetricUpdate;
import nl.sascom.backplanepublic.common.ResponseType;

public class MetricValueUpdate
extends MetricUpdate {
    private String key;
    private Object value;
    private GregorianCalendar time;
    private boolean debug;
    private String path;

    public MetricValueUpdate(UUID uUID, String string, String string2, Object object) {
        super(uUID);
        this.path = string;
        this.key = string2;
        this.value = object;
        this.time = new GregorianCalendar();
    }

    public MetricValueUpdate(byte[] byArray) {
        super(byArray);
    }

    @Override
    public void setData(ObjectNode objectNode) {
        this.key = objectNode.get("key").asText();
        this.value = objectNode.get("value").asText();
        this.path = objectNode.get("path").asText();
        this.time = new GregorianCalendar();
        this.time.setTimeInMillis(objectNode.get("time").asLong());
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = super.toJson();
        objectNode.put("key", this.key);
        objectNode.put("path", this.getPath());
        if (this.value instanceof String) {
            objectNode.put("value", (String)this.value);
        } else if (this.value instanceof Long) {
            objectNode.put("value", (Long)this.value);
        } else if (this.value instanceof Double) {
            objectNode.put("value", (Double)this.value);
        } else if (this.value == null) {
            objectNode.putNull("value");
        } else {
            objectNode.put("value", this.value.toString());
        }
        objectNode.put("time", this.time.getTimeInMillis());
        if (this.debug) {
            objectNode.put("debug", true);
        }
        return objectNode;
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.METRIC_UPDATE;
    }

    public String getKey() {
        return this.key;
    }

    public long getLongValue() {
        return (Long)this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        return (String)this.value;
    }

    public String toString() {
        return "MetricUpdate: " + this.key + " = " + this.value;
    }

    @Override
    public String getSubType() {
        return this.key;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

