/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import nl.sascom.backplanepublic.client.WebSocketNodeTransport;
import nl.sascom.backplanepublic.common.EndPointId;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.UpdateInterface;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxIdleTime=3600000, maxBinaryMessageSize=0x20000000)
public class CommunicationWebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(nl.sascom.backplanepublic.common.WebSocket.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private WebSocketNodeTransport webSocketNodeTransport;
    private Session session;

    public CommunicationWebSocket(WebSocketNodeTransport webSocketNodeTransport) {
        this.webSocketNodeTransport = webSocketNodeTransport;
    }

    @OnWebSocketConnect
    public void onOpen(Session session) {
        this.session = session;
        this.webSocketNodeTransport.onOpen();
    }

    @OnWebSocketMessage
    public void onBinary(byte[] byArray, int n, int n2) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2).order(ByteOrder.LITTLE_ENDIAN);
            int n3 = byteBuffer.getInt();
            byte[] byArray2 = new byte[n3];
            byteBuffer.get(byArray2);
            UUID uUID = UUID.fromString(new String(byArray2, StandardCharsets.UTF_8));
            ResponseType responseType = ResponseType.fromId(byteBuffer.get());
            int n4 = byteBuffer.getInt();
            byte[] byArray3 = new byte[n4];
            byteBuffer.get(byArray3);
            this.webSocketNodeTransport.newData(uUID, responseType, byArray3);
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
        }
    }

    @OnWebSocketError
    public void onError(Throwable throwable) {
        if (throwable instanceof CloseException) {
            CloseException closeException = (CloseException)throwable;
            if (!(closeException.getCause() instanceof TimeoutException)) {
                LOGGER.error("", throwable);
            }
        } else {
            LOGGER.error("", throwable);
        }
    }

    @OnWebSocketMessage
    public void onText(String string) {
        try {
            ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readValue(string, ObjectNode.class);
            if (objectNode.has("endPointId")) {
                this.webSocketNodeTransport.setEndPointId(EndPointId.fromString(objectNode.get("endPointId").asText()));
            } else {
                UpdateInterface updateInterface = JsonUpdate.create(objectNode);
                this.webSocketNodeTransport.newData(updateInterface.getId(), updateInterface.getResponseType(), updateInterface.toMessageBytes());
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("", throwable);
        }
    }

    @OnWebSocketClose
    public void onClose(int n, String string) {
        if (n == 1001 || n == 1006) {
            this.webSocketNodeTransport.onCloseReconnect();
        } else if (n != 1000) {
            LOGGER.error(n + " " + string);
        }
    }

    public void send(ObjectNode objectNode) {
        try {
            this.session.getRemote().sendString(objectNode.toString());
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }

    public void send(byte[] byArray) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 4).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(3);
            byteBuffer.put(byArray);
            byteBuffer.position(0);
            LOGGER.info(Arrays.toString(byteBuffer.array()));
            LOGGER.info("Sending " + byteBuffer.capacity());
            this.session.getRemote().sendBytes(byteBuffer);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
    }
}

