/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import nl.bimbase.bimworks.api.checks.ModelCheckOutput;
import nl.bimbase.bimworks.client.ModelCheckResults;
import nl.bimbase.bimworks.client.Task;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class RunChecksTask
extends Task<ModelCheckResults> {
    private UUID modelCheckDefinitionSet;
    private Set<UUID> versionUuids;
    private ObjectNode input;

    public RunChecksTask(UUID uUID, Set<UUID> set, ObjectNode objectNode) {
        this.modelCheckDefinitionSet = uUID;
        this.versionUuids = set;
        this.input = objectNode;
    }

    @Override
    public Request createRequest() {
        Request request = new Request();
        request.setTaskName("RunChecks");
        ArrayNode arrayNode = Response.createArray();
        for (UUID uUID : this.versionUuids) {
            arrayNode.add(uUID.toString());
        }
        request.getObjectInput().put("uuid", this.modelCheckDefinitionSet.toString());
        request.getObjectInput().set("version_uuids", (JsonNode)arrayNode);
        request.getObjectInput().set("input", (JsonNode)this.input);
        return request;
    }

    public ObjectNode getInput() {
        return this.input;
    }

    public UUID getModelCheckDefinitionSet() {
        return this.modelCheckDefinitionSet;
    }

    public Set<UUID> getVersionUuids() {
        return this.versionUuids;
    }

    @Override
    public ModelCheckResults get() throws InterruptedException, ExecutionException {
        ModelCheckResults modelCheckResults = new ModelCheckResults();
        try {
            Response response = this.getClientTask().await();
            ObjectNode objectNode = response.getObjectOutput();
            ObjectNode objectNode2 = (ObjectNode)objectNode.get("output");
            modelCheckResults.setUuid(UUID.fromString(objectNode.get("uuid").asText()));
            Iterator iterator = objectNode2.fieldNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ObjectNode objectNode3 = (ObjectNode)objectNode2.get(string);
                modelCheckResults.put(string, (ModelCheckOutput)Response.OBJECT_MAPPER.convertValue((Object)objectNode3, ModelCheckOutput.class));
            }
            return modelCheckResults;
        }
        catch (ExecuteException executeException) {
            executeException.printStackTrace();
            return null;
        }
    }
}

