package nl.bimbase.bimworks.client;

import java.util.concurrent.CompletableFuture;

import nl.sascom.backplanepublic.client.AsyncTask;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.ProgressListener;
import nl.sascom.backplanepublic.common.Request;

public abstract class Task<T> extends CompletableFuture<T> {
	private Request request;
	private AsyncTask clientTask;
	public abstract Request createRequest();
	
	public ClientTask createAsyncTask(BimWorksClient bimWorksClient) {
		Request request = createRequestInternal();
		bimWorksClient.getNodeClient().augmentRequest(request);
		ClientTask asyncTask = bimWorksClient.createAsyncTask(request);
		return asyncTask;
	}
	
	private Request createRequestInternal() {
		if (this.request == null) {
			this.request = createRequest();
		}
		return this.request;
	}
	
	public Request getRequest() {
		return createRequestInternal();
	}

	public void setProgressListener(ProgressListener progressListener) {
		clientTask.addProgressListener(progressListener);
	}
	
	public void executeAsync(BimWorksClient bimWorksClient) {
		clientTask = (AsyncTask) createAsyncTask(bimWorksClient);
		try {
			clientTask.exec();
		} catch (ExecuteException e) {
			e.printStackTrace();
		}
	}
	
	public AsyncTask getClientTask() {
		return clientTask;
	}
}