/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import java.util.UUID;
import nl.sascom.backplanepublic.common.HttpEndPointId;
import nl.sascom.backplanepublic.common.LocalEndPointId;
import nl.sascom.backplanepublic.common.SocketEndPointId;
import nl.sascom.backplanepublic.common.SubExecutionEndPointId;
import nl.sascom.backplanepublic.common.SyncHttpEndPointId;
import nl.sascom.backplanepublic.common.WebSocketEndPointId;
import nl.sascom.backplanepublic.common.library.InvalidEndPointException;

public abstract class EndPointId {
    protected String id;

    public EndPointId(String string) {
        if (string.startsWith("w") || string.startsWith("i") || string.startsWith("h") || string.startsWith("z") || string.startsWith("s") | string.startsWith("q")) {
            string = string.substring(1);
        }
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public abstract String getSpecifiedId();

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.getSpecifiedId() + ")";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getSpecifiedId() == null ? 0 : this.getSpecifiedId().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndPointId endPointId = (EndPointId)object;
        return !(this.getSpecifiedId() == null ? endPointId.getSpecifiedId() != null : !this.getSpecifiedId().equals(endPointId.getSpecifiedId()));
    }

    public static EndPointId fromString(String string) throws InvalidEndPointException {
        if (string.startsWith("w")) {
            return new WebSocketEndPointId(string.substring(1));
        }
        if (string.startsWith("h")) {
            return new HttpEndPointId(string.substring(1));
        }
        if (string.startsWith("i")) {
            return new LocalEndPointId(UUID.fromString(string.substring(1)));
        }
        if (string.startsWith("s")) {
            return new SocketEndPointId(string.substring(1));
        }
        if (string.startsWith("q")) {
            return new SyncHttpEndPointId(string.substring(1));
        }
        if (string.startsWith("S")) {
            return new SubExecutionEndPointId(string.substring(1));
        }
        throw new InvalidEndPointException(string);
    }
}

