/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.geometry.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import nl.bimbase.geometry.types.Matrix4d;

public class Vector3d {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public double[] values;

    public Vector3d(double[] dArray) {
        this.values = dArray;
    }

    public Vector3d() {
        this.values = new double[]{0.0, 0.0, 0.0};
    }

    public Vector3d(double d, double d2, double d3) {
        this.values = new double[]{d, d2, d3};
    }

    public Vector3d(double d) {
        this.values = new double[]{d, d, d};
    }

    public Vector3d(Vector3d vector3d) {
        this.values = new double[]{vector3d.getX(), vector3d.getY(), vector3d.getZ()};
    }

    public boolean isOk() {
        for (double d : this.values) {
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            return true;
        }
        return true;
    }

    public static double[] cross(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = dArray3[0];
        double d5 = dArray3[1];
        double d6 = dArray3[2];
        dArray[0] = d2 * d6 - d3 * d5;
        dArray[1] = d3 * d4 - d * d6;
        dArray[2] = d * d5 - d2 * d4;
        return dArray;
    }

    public boolean hasNaN() {
        for (double d : this.values) {
            if (!Double.isNaN(d)) continue;
            return true;
        }
        return false;
    }

    public Vector3d add(Vector3d vector3d) {
        return new Vector3d(this.values[0] + vector3d.values[0], this.values[1] + vector3d.values[1], this.values[2] + vector3d.values[2]);
    }

    public double getX() {
        return this.values[0];
    }

    public double getY() {
        return this.values[1];
    }

    public double getZ() {
        return this.values[2];
    }

    public JsonNode toJson() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("x", this.values[0]);
        objectNode.put("y", this.values[1]);
        objectNode.put("z", this.values[2]);
        return objectNode;
    }

    public static float[] normalize(float[] fArray, float[] fArray2) {
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = fArray2[2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if (f4 > 0.0f) {
            f4 = (float)(1.0 / Math.sqrt(f4));
        }
        fArray[0] = fArray2[0] * f4;
        fArray[1] = fArray2[1] * f4;
        fArray[2] = fArray2[2] * f4;
        return fArray;
    }

    public static Vector3d fromJson(JsonNode jsonNode) {
        if (jsonNode instanceof ArrayNode) {
            return new Vector3d(jsonNode.get(0).asDouble(), jsonNode.get(1).asDouble(), jsonNode.get(2).asDouble());
        }
        if (jsonNode instanceof ObjectNode) {
            return new Vector3d(jsonNode.get("x").asDouble(), jsonNode.get("y").asDouble(), jsonNode.get("z").asDouble());
        }
        return null;
    }

    public void set(double d, double d2, double d3) {
        this.values[0] = d;
        this.values[1] = d2;
        this.values[2] = d3;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public Vector3d copy() {
        return new Vector3d(this.values[0], this.values[1], this.values[2]);
    }

    public void setX(double d) {
        this.values[0] = d;
    }

    public void setY(double d) {
        this.values[1] = d;
    }

    public void setZ(double d) {
        this.values[2] = d;
    }

    public double[] getDouble4() {
        return new double[]{this.values[0], this.values[1], this.values[2], 1.0};
    }

    public void transform(Vector3d vector3d, Matrix4d matrix4d) {
        double[] dArray = matrix4d.matrix;
        double d = this.values[0];
        double d2 = this.values[1];
        double d3 = this.values[2];
        double d4 = dArray[3] * d + dArray[7] * d2 + dArray[11] * d3 + dArray[15];
        if (!Double.isFinite(d4)) {
            d4 = 1.0;
        }
        vector3d.values[0] = (dArray[0] * d + dArray[4] * d2 + dArray[8] * d3 + dArray[12]) / d4;
        vector3d.values[1] = (dArray[1] * d + dArray[5] * d2 + dArray[9] * d3 + dArray[13]) / d4;
        vector3d.values[2] = (dArray[2] * d + dArray[6] * d2 + dArray[10] * d3 + dArray[14]) / d4;
    }

    public void normalizeInline() {
        double d = this.values[0];
        double d2 = this.values[1];
        double d3 = this.values[2];
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 > 0.0) {
            d4 = (float)(1.0 / Math.sqrt(d4));
        }
        this.values[0] = this.values[0] * d4;
        this.values[1] = this.values[1] * d4;
        this.values[2] = this.values[2] * d4;
    }

    public void writeToAsFloat(ByteBuffer byteBuffer) {
        byteBuffer.putFloat((float)this.values[0]);
        byteBuffer.putFloat((float)this.values[1]);
        byteBuffer.putFloat((float)this.values[2]);
    }

    public float[] toFloatArray() {
        return new float[]{(float)this.values[0], (float)this.values[1], (float)this.values[2]};
    }

    public void translateInline(Vector3d vector3d) {
        this.values[0] = this.values[0] + vector3d.getX();
        this.values[1] = this.values[1] + vector3d.getY();
        this.values[2] = this.values[2] + vector3d.getZ();
    }

    public Vector3d invert() {
        return new Vector3d(-this.values[0], -this.values[1], -this.values[2]);
    }

    public double get(int n) {
        return this.values[n];
    }

    public Vector3d scale(double d) {
        return new Vector3d(this.getX() * d, this.getY() * d, this.getZ() * d);
    }

    public static void normalizeInline(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if (f4 > 0.0f) {
            f4 = (float)(1.0 / Math.sqrt(f4));
        }
        fArray[0] = fArray[0] * f4;
        fArray[1] = fArray[1] * f4;
        fArray[2] = fArray[2] * f4;
    }

    public static double[] subtract(double[] dArray, double[] dArray2) {
        return new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
    }

    public double length() {
        return Math.sqrt(this.values[0] * this.values[0] + this.values[1] * this.values[1] + this.values[2] * this.values[2]);
    }

    public void divideInline(Vector3d vector3d) {
    }

    public void divideInline(double d) {
        this.values[0] = this.values[0] / d;
        this.values[1] = this.values[1] / d;
        this.values[2] = this.values[2] / d;
    }
}

