/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.geometry.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.primitives.UnsignedBytes;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import nl.bimbase.node.common.utils.LittleEndianDataOutputStream;
import nl.sascom.backplanepublic.common.Response;

public class Color4f {
    public static final Color4f BLACK = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color4f RED = new Color4f(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color4f BLUE = new Color4f(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color4f PURPLE = new Color4f(0.5f, 0.5f, 0.0f, 1.0f);
    private float r;
    private float g;
    private float b;
    private float a;

    public Color4f(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
    }

    public Color4f() {
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.a);
        n = 31 * n + Float.floatToIntBits(this.b);
        n = 31 * n + Float.floatToIntBits(this.g);
        n = 31 * n + Float.floatToIntBits(this.r);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Color4f color4f = (Color4f)object;
        if (Float.floatToIntBits(this.a) != Float.floatToIntBits(color4f.a)) {
            return false;
        }
        if (Float.floatToIntBits(this.b) != Float.floatToIntBits(color4f.b)) {
            return false;
        }
        if (Float.floatToIntBits(this.g) != Float.floatToIntBits(color4f.g)) {
            return false;
        }
        return Float.floatToIntBits(this.r) == Float.floatToIntBits(color4f.r);
    }

    public void set(int n, float f) {
        if (n == 0) {
            this.r = f;
        } else if (n == 1) {
            this.g = f;
        } else if (n == 2) {
            this.b = f;
        } else if (n == 3) {
            this.a = f;
        }
    }

    public boolean isBlack() {
        return this.r == 0.0f && this.g == 0.0f && this.b == 0.0f && this.a == 1.0f;
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getG() {
        return this.g;
    }

    public float getR() {
        return this.r;
    }

    public String toString() {
        return this.r + ", " + this.g + ", " + this.b + ", " + this.a;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat(this.r);
        dataOutputStream.writeFloat(this.g);
        dataOutputStream.writeFloat(this.b);
        dataOutputStream.writeFloat(this.a);
    }

    public void write(ByteBuffer byteBuffer) {
        byteBuffer.putFloat(this.r);
        byteBuffer.putFloat(this.g);
        byteBuffer.putFloat(this.b);
        byteBuffer.putFloat(this.a);
    }

    public void writeAsUnsignedByteArray(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.r * 255.0f))));
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.g * 255.0f))));
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.b * 255.0f))));
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.a * 255.0f))));
    }

    public void write(LittleEndianDataOutputStream littleEndianDataOutputStream) throws IOException {
        littleEndianDataOutputStream.writeFloat(this.r);
        littleEndianDataOutputStream.writeFloat(this.g);
        littleEndianDataOutputStream.writeFloat(this.b);
        littleEndianDataOutputStream.writeFloat(this.a);
    }

    public static Color4f read(DataInput dataInput) throws IOException {
        Color4f color4f = new Color4f();
        color4f.setR(dataInput.readFloat());
        color4f.setG(dataInput.readFloat());
        color4f.setB(dataInput.readFloat());
        color4f.setA(dataInput.readFloat());
        return color4f;
    }

    public static Color4f read(ByteBuffer byteBuffer) throws IOException {
        Color4f color4f = new Color4f();
        color4f.setR(byteBuffer.getFloat());
        color4f.setG(byteBuffer.getFloat());
        color4f.setB(byteBuffer.getFloat());
        color4f.setA(byteBuffer.getFloat());
        return color4f;
    }

    private void setA(float f) {
        this.a = f;
    }

    private void setB(float f) {
        this.b = f;
    }

    private void setG(float f) {
        this.g = f;
    }

    private void setR(float f) {
        this.r = f;
    }

    public static Color4f from(byte[] byArray) {
        return new Color4f((float)UnsignedBytes.toInt((byte)byArray[0]) / 255.0f, (float)UnsignedBytes.toInt((byte)byArray[1]) / 255.0f, (float)UnsignedBytes.toInt((byte)byArray[2]) / 255.0f, (float)UnsignedBytes.toInt((byte)byArray[3]) / 255.0f);
    }

    public JsonNode toJson() {
        ObjectNode objectNode = Response.createObject();
        objectNode.put("type", "color");
        objectNode.put("r", this.r);
        objectNode.put("g", this.g);
        objectNode.put("b", this.b);
        objectNode.put("a", this.a);
        return objectNode;
    }

    public static Color4f from(ObjectNode objectNode) {
        Color4f color4f = new Color4f();
        color4f.setR((float)objectNode.get("r").asDouble());
        color4f.setG((float)objectNode.get("g").asDouble());
        color4f.setB((float)objectNode.get("b").asDouble());
        color4f.setA((float)objectNode.get("a").asDouble());
        return color4f;
    }

    public String toHexString() {
        return String.format("#%02x%02x%02x%02x", (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f), (int)(this.a * 255.0f));
    }

    public ByteBuffer toUnsignedByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.r * 255.0f))));
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.g * 255.0f))));
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.b * 255.0f))));
        byteBuffer.put(UnsignedBytes.checkedCast((long)((long)(this.a * 255.0f))));
        return byteBuffer.position(0);
    }
}

