/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import java.io.OutputStream;
import java.util.UUID;
import nl.bimbase.bimworks.client.BimWorksClient;
import nl.bimbase.bimworks.client.Task;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.StreamDescriptor;

public class DownloadCheckResultsAsBcfInput
extends Task {
    private UUID checkResultsUuid;
    private BimWorksClient bimWorksClient;

    public DownloadCheckResultsAsBcfInput(BimWorksClient bimWorksClient, UUID uUID) {
        this.bimWorksClient = bimWorksClient;
        this.checkResultsUuid = uUID;
    }

    public UUID getCheckResultsUuid() {
        return this.checkResultsUuid;
    }

    @Override
    public Request createRequest() {
        Request request = new Request();
        request.setTaskName("DownloadCheckResultsAsBcf");
        request.getObjectInput().put("uuid", this.checkResultsUuid.toString());
        return request;
    }

    public void downloadTo(OutputStream outputStream) {
        try {
            Response response = this.getClientTask().await();
            for (StreamDescriptor streamDescriptor : response.getAttachedStreams()) {
                this.bimWorksClient.getApi().getStream(streamDescriptor.getKey(), outputStream);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            executeException.printStackTrace();
        }
    }
}

