/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.geometry.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import nl.bimbase.geometry.types.Matrix;

public class Matrix3d {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Matrix3d IDENTITY = new Matrix3d(1.0, 0.0, 0.0, 0, 1.0, 0.0, 0.0, 0, 1.0);
    public double[] matrix;
    private FloatBuffer floatBuffer;

    public Matrix3d() {
        this.matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    }

    public Matrix3d(double d, double d2, double d3, int n, double d4, double d5, double d6, int n2, double d7) {
        this.matrix = new double[]{d, d2, d3, n, d4, d5, d6, n2, d7};
    }

    public static Matrix3d create(double[] dArray) {
        return new Matrix3d(dArray);
    }

    public Matrix3d(double[] dArray) {
        this.matrix = dArray;
    }

    public double[] multiply(double d, double d2, double d3) {
        double[] dArray = new double[]{this.matrix[0] * d + this.matrix[4] * d2 + this.matrix[8] * d3 + this.matrix[12] * 1.0, this.matrix[1] * d + this.matrix[5] * d2 + this.matrix[9] * d3 + this.matrix[13] * 1.0, this.matrix[2] * d + this.matrix[6] * d2 + this.matrix[10] * d3 + this.matrix[14] * 1.0, this.matrix[3] * d + this.matrix[7] * d2 + this.matrix[11] * d3 + this.matrix[15] * 1.0};
        return dArray;
    }

    public double[] multiply(double[] dArray, double d, double d2, double d3) {
        dArray[0] = this.matrix[0] * d + this.matrix[4] * d2 + this.matrix[8] * d3 + this.matrix[12] * 1.0;
        dArray[1] = this.matrix[1] * d + this.matrix[5] * d2 + this.matrix[9] * d3 + this.matrix[13] * 1.0;
        dArray[2] = this.matrix[2] * d + this.matrix[6] * d2 + this.matrix[10] * d3 + this.matrix[14] * 1.0;
        return dArray;
    }

    public Matrix3d multiply(Matrix3d matrix3d) {
        Matrix3d matrix3d2 = new Matrix3d();
        Matrix.multiplyMM(matrix3d2.matrix, 0, this.matrix, 0, matrix3d.matrix, 0);
        return matrix3d2;
    }

    public Matrix3d multiply(Matrix3d matrix3d, Matrix3d matrix3d2) {
        Matrix3d matrix3d3 = new Matrix3d();
        Matrix.multiplyMM(matrix3d3.matrix, 0, this.matrix, 0, matrix3d2.matrix, 0);
        return matrix3d3;
    }

    public void scaleInline(double d, double d2, double d3) {
        int n = 0;
        while (n < 4) {
            int n2;
            int n3 = n2 = n++;
            this.matrix[n3] = this.matrix[n3] * d;
            int n4 = 4 + n2;
            this.matrix[n4] = this.matrix[n4] * d2;
            int n5 = 8 + n2;
            this.matrix[n5] = this.matrix[n5] * d3;
        }
    }

    public Matrix3d scale(double d, double d2, double d3) {
        Matrix3d matrix3d = this.copy();
        for (int i = 0; i < 4; ++i) {
            int n = i;
            matrix3d.matrix[n] = matrix3d.matrix[n] * d;
            int n2 = 4 + i;
            matrix3d.matrix[n2] = matrix3d.matrix[n2] * d2;
            int n3 = 8 + i;
            matrix3d.matrix[n3] = matrix3d.matrix[n3] * d3;
        }
        return matrix3d;
    }

    public void translateInline(Matrix3d matrix3d, double d, double d2, double d3) {
        for (int i = 0; i < 4; ++i) {
            this.matrix[12 + i] = this.matrix[i] * d + this.matrix[4 + i] * d2 + this.matrix[8 + i] * d3 + this.matrix[12 + i];
        }
    }

    public boolean hasNaN() {
        for (int i = 0; i < 16; ++i) {
            if (!Double.isNaN(this.matrix[i])) continue;
            return true;
        }
        return false;
    }

    public JsonNode toJson() {
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < 16; ++i) {
            arrayNode.add(this.matrix[i]);
        }
        return arrayNode;
    }

    public Matrix3d invert() {
        Matrix3d matrix3d = new Matrix3d();
        double d = this.matrix[0];
        double d2 = this.matrix[8];
        double d3 = this.matrix[4];
        double d4 = this.matrix[5];
        double d5 = this.matrix[7];
        double d6 = d2 * d3 - d4 * d5;
        double d7 = this.matrix[1];
        double d8 = this.matrix[3];
        double d9 = this.matrix[6];
        double d10 = -d2 * d8 + d4 * d9;
        double d11 = this.matrix[2];
        double d12 = d5 * d8 - d3 * d9;
        double d13 = d * d6 + d7 * d10 + d11 * d12;
        if (Double.isNaN(d13) || d13 == 0.0) {
            return null;
        }
        d13 = 1.0 / d13;
        matrix3d.matrix[0] = d6 * d13;
        matrix3d.matrix[1] = (-d2 * d7 + d11 * d5) * d13;
        matrix3d.matrix[2] = (d4 * d7 - d11 * d3) * d13;
        matrix3d.matrix[3] = d10 * d13;
        matrix3d.matrix[4] = (d2 * d - d11 * d9) * d13;
        matrix3d.matrix[5] = (-d4 * d + d11 * d8) * d13;
        matrix3d.matrix[6] = d12 * d13;
        matrix3d.matrix[7] = (-d5 * d + d7 * d9) * d13;
        matrix3d.matrix[8] = (d3 * d - d7 * d8) * d13;
        return matrix3d;
    }

    public static Matrix3d fromJson(ArrayNode arrayNode) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.matrix = new double[16];
        for (int i = 0; i < 16; ++i) {
            matrix3d.matrix[i] = arrayNode.get(i).asDouble();
        }
        return matrix3d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            stringBuilder.append(this.matrix[i]);
            if ((i + 1) % 3 == 0) {
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(72).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 9; ++i) {
            byteBuffer.putDouble(this.matrix[i]);
        }
        return byteBuffer.array();
    }

    public static Matrix3d read(DataInput dataInput) throws IOException {
        Matrix3d matrix3d = new Matrix3d();
        byte[] byArray = new byte[72];
        dataInput.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 9; ++i) {
            matrix3d.matrix[i] = byteBuffer.getDouble();
        }
        return matrix3d;
    }

    public static Matrix3d read(ByteBuffer byteBuffer) throws IOException {
        Matrix3d matrix3d = new Matrix3d();
        for (int i = 0; i < 9; ++i) {
            matrix3d.matrix[i] = byteBuffer.getDouble();
        }
        return matrix3d;
    }

    public Matrix3d copy() {
        double[] dArray = new double[9];
        System.arraycopy(this.matrix, 0, dArray, 0, 9);
        return new Matrix3d(dArray);
    }

    public Matrix3d translate(double d, double d2) {
        Matrix3d matrix3d = this.copy();
        return matrix3d;
    }

    public void multiply(double[] dArray, double[] dArray2) {
        Matrix.multiplyMV(dArray, 0, this.matrix, 0, dArray2, 0);
    }

    public void multiply(float[] fArray, float[] fArray2) {
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = fArray2[2];
        fArray[0] = (float)((double)f * this.matrix[0] + (double)f2 * this.matrix[3] + (double)f3 * this.matrix[6]);
        fArray[1] = (float)((double)f * this.matrix[1] + (double)f2 * this.matrix[4] + (double)f3 * this.matrix[7]);
        fArray[2] = (float)((double)f * this.matrix[2] + (double)f2 * this.matrix[5] + (double)f3 * this.matrix[8]);
    }

    public void multiply(float[] fArray, ByteBuffer byteBuffer, int n) {
        float f = byteBuffer.getFloat(n + 0);
        float f2 = byteBuffer.getFloat(n + 4);
        float f3 = byteBuffer.getFloat(n + 8);
        fArray[0] = (float)((double)f * this.matrix[0] + (double)f2 * this.matrix[3] + (double)f3 * this.matrix[6]);
        fArray[1] = (float)((double)f * this.matrix[1] + (double)f2 * this.matrix[4] + (double)f3 * this.matrix[7]);
        fArray[2] = (float)((double)f * this.matrix[2] + (double)f2 * this.matrix[5] + (double)f3 * this.matrix[8]);
    }

    public void transform(float[] fArray, float[] fArray2) {
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = fArray2[2];
        fArray[0] = (float)((double)f * this.matrix[0] + (double)f2 * this.matrix[3] + (double)f3 * this.matrix[6]);
        fArray[1] = (float)((double)f * this.matrix[1] + (double)f2 * this.matrix[4] + (double)f3 * this.matrix[7]);
        fArray[2] = (float)((double)f * this.matrix[2] + (double)f2 * this.matrix[5] + (double)f3 * this.matrix[8]);
    }

    public void transform(double[] dArray, double[] dArray2) {
        double d = dArray2[0];
        double d2 = dArray2[1];
        dArray[0] = d * this.matrix[0] + d2 * this.matrix[3] + this.matrix[6];
        dArray[1] = d * this.matrix[1] + d2 * this.matrix[4] + this.matrix[7];
    }

    public void translateInline(double d, double d2, double d3) {
        for (int i = 0; i < 4; ++i) {
            this.matrix[12 + i] = this.matrix[i] * d + this.matrix[4 + i] * d2 + this.matrix[8 + i] * d3 + this.matrix[12 + i];
        }
    }

    public boolean isOk() {
        for (double d : this.matrix) {
            if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
            return false;
        }
        return true;
    }

    public String to2dSpacedString(double d) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.scaleInline(d, d, d);
        return matrix3d.multiply(this).to2dSpacedString();
    }

    public String to2dSpacedString() {
        return this.matrix[0] + " " + this.matrix[1] + " " + this.matrix[4] + " " + this.matrix[5] + " " + this.matrix[12] + " " + this.matrix[13];
    }

    public double[] to2DMatrix() {
        return new double[]{this.matrix[0], this.matrix[1], this.matrix[4], this.matrix[5], this.matrix[12], this.matrix[13]};
    }

    public double[] to2DMatrix(double d) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.scaleInline(d, d, d);
        return matrix3d.multiply(this).to2DMatrix();
    }

    public Matrix3d transpose() {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.matrix[0] = this.matrix[0];
        matrix3d.matrix[1] = this.matrix[3];
        matrix3d.matrix[2] = this.matrix[6];
        matrix3d.matrix[3] = this.matrix[1];
        matrix3d.matrix[4] = this.matrix[4];
        matrix3d.matrix[5] = this.matrix[7];
        matrix3d.matrix[6] = this.matrix[2];
        matrix3d.matrix[7] = this.matrix[5];
        matrix3d.matrix[8] = this.matrix[8];
        return matrix3d;
    }

    public FloatBuffer asFloatBuffer() {
        if (this.floatBuffer == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(36).order(ByteOrder.LITTLE_ENDIAN);
            for (double d : this.matrix) {
                byteBuffer.putFloat((float)d);
            }
            this.floatBuffer = byteBuffer.position(0).asFloatBuffer();
        }
        return this.floatBuffer;
    }

    public static Matrix3d identity() {
        return IDENTITY;
    }

    public void writeTo(ByteBuffer byteBuffer) {
        for (int i = 0; i < 9; ++i) {
            byteBuffer.putDouble(this.matrix[i]);
        }
    }

    public void writeToAsFloat(ByteBuffer byteBuffer) {
        for (int i = 0; i < 9; ++i) {
            byteBuffer.putFloat((float)this.matrix[i]);
        }
    }

    public Matrix3d scaleInline(double d, double d2) {
        this.matrix[0] = d * this.matrix[0];
        this.matrix[1] = d * this.matrix[1];
        this.matrix[2] = d * this.matrix[2];
        this.matrix[3] = d2 * this.matrix[3];
        this.matrix[4] = d2 * this.matrix[4];
        this.matrix[5] = d2 * this.matrix[5];
        this.matrix[6] = this.matrix[6];
        this.matrix[7] = this.matrix[7];
        this.matrix[8] = this.matrix[8];
        this.floatBuffer = null;
        return this;
    }

    public void translateInline(double d, double d2) {
        double d3 = this.matrix[0];
        double d4 = this.matrix[1];
        double d5 = this.matrix[2];
        double d6 = this.matrix[3];
        double d7 = this.matrix[4];
        double d8 = this.matrix[5];
        double d9 = this.matrix[6];
        double d10 = this.matrix[7];
        double d11 = this.matrix[8];
        this.matrix[6] = d * d3 + d2 * d6 + d9;
        this.matrix[7] = d * d4 + d2 * d7 + d10;
        this.matrix[8] = d * d5 + d2 * d8 + d11;
        this.floatBuffer = null;
    }

    public void transformInline(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        dArray[0] = this.matrix[0] * d + this.matrix[3] * d2 + this.matrix[6];
        dArray[1] = this.matrix[1] * d + this.matrix[4] * d2 + this.matrix[7];
    }

    public ByteBuffer asByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.matrix.length; ++i) {
            byteBuffer.putFloat((float)this.matrix[i]);
        }
        return byteBuffer.position(0);
    }

    public Matrix3d scaleInline(double d) {
        return this.scaleInline(d, d);
    }

    public void multiply(double[][] dArray) {
    }
}

