/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.api.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.bimbase.bimworks.api.checks.CheckResult;
import nl.bimbase.bimworks.api.checks.CheckResults;
import nl.bimbase.bimworks.api.checks.ModelCheckOutput;
import nl.bimbase.bimworks.api.checks.ObjectCheckResult;
import nl.bimbase.bimworks.api.checks.ObjectCheckResultSummary;

public class ObjectCheckResults
implements CheckResults {
    private final List<ObjectCheckResult> results = new ArrayList<ObjectCheckResult>();
    private final ObjectCheckResultSummary summary = new ObjectCheckResultSummary();

    public Collection<ObjectCheckResult> getResults() {
        return this.results;
    }

    public ObjectCheckResultSummary getSummary() {
        return this.summary;
    }

    public void updateSummary(ModelCheckOutput modelCheckOutput) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (ObjectCheckResult objectCheckResult : this.results) {
            if (objectCheckResult.getCheckResult() == CheckResult.ERROR) {
                ++n;
            } else if (objectCheckResult.getCheckResult() == CheckResult.WARNING) {
                ++n3;
            } else if (objectCheckResult.getCheckResult() == CheckResult.SUCCESS) {
                ++n2;
            }
            if (objectCheckResult.getAuxiliaryGeometry() == null || objectCheckResult.getAuxiliaryGeometry().isEmpty()) continue;
            bl = true;
        }
        if (modelCheckOutput.getOverallResult() != null) {
            this.getSummary().setOverallResult(modelCheckOutput.getOverallResult());
        } else if (n > 0) {
            this.getSummary().setOverallResult(CheckResult.ERROR);
        } else if (n3 > 0) {
            this.getSummary().setOverallResult(CheckResult.WARNING);
        } else {
            this.getSummary().setOverallResult(CheckResult.SUCCESS);
        }
        this.getSummary().setErrors(n);
        this.getSummary().setSuccesses(n2);
        this.getSummary().setWarning(n3);
        this.getSummary().setHasAuxiliary(bl);
        modelCheckOutput.setOverallResult(this.getSummary().getOverallResult());
    }
}

