package nl.bimbase.bimworks.client;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.bimbase.bimworks.api.checks.ModelCheckOutput;
import nl.sascom.backplanepublic.client.AsyncTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class RunChecksTask extends Task<ModelCheckResults> {
	private UUID modelCheckDefinitionSet;
	private Set<UUID> versionUuids;
	private ObjectNode input;

	public RunChecksTask(UUID modelCheckDefinitionSet, Set<UUID> versionUuids, ObjectNode input) {
		this.modelCheckDefinitionSet = modelCheckDefinitionSet;
		this.versionUuids = versionUuids;
		this.input = input;
	}
	
	@Override
	public Request createRequest() {
		Request request = new Request();
		request.setTaskName("RunChecks");
		ArrayNode modelsNode = Response.createArray();
		for (UUID versionUuid : versionUuids) {
			modelsNode.add(versionUuid.toString());
		}
		request.getObjectInput().put("uuid", modelCheckDefinitionSet.toString());
		request.getObjectInput().set("version_uuids", modelsNode);
		request.getObjectInput().set("input", input);
		return request;
	}
	
	public ObjectNode getInput() {
		return input;
	}
	
	public UUID getModelCheckDefinitionSet() {
		return modelCheckDefinitionSet;
	}
	
	public Set<UUID> getVersionUuids() {
		return versionUuids;
	}

	@Override
	public ModelCheckResults get() throws InterruptedException, ExecutionException {
		ModelCheckResults modelCheckResults = new ModelCheckResults();
		try {
			Response response = getClientTask().await();
			ObjectNode objectOutput = response.getObjectOutput();
			ObjectNode outputNode = (ObjectNode) objectOutput.get("output");
			modelCheckResults.setUuid(UUID.fromString(objectOutput.get("uuid").asText()));
			Iterator<String> fieldNames = outputNode.fieldNames();
			while (fieldNames.hasNext()) {
				String fieldName = fieldNames.next();
				ObjectNode checkOutputNode = (ObjectNode) outputNode.get(fieldName);
				modelCheckResults.put(fieldName, Response.OBJECT_MAPPER.convertValue(checkOutputNode, ModelCheckOutput.class));
			}
			return modelCheckResults;
		} catch (ExecuteException e) {
			e.printStackTrace();
		}
		return null;
	}
}