package nl.bimbase.bimworks.client;

import java.util.Set;
import java.util.UUID;

import com.fasterxml.jackson.databind.node.ObjectNode;

public class ModelChecks extends SubApi {

	public ModelChecks(BimWorksClient bimWorksClient) {
		super(bimWorksClient);
	}
	
	public RunChecksTask runChecks(UUID modelCheckDefinitionSet, Set<UUID> versionUuids, ObjectNode input) throws BimWorksException {
		RunChecksTask runChecksTask = new RunChecksTask(modelCheckDefinitionSet, versionUuids, input);
		runChecksTask.executeAsync(getBimWorksClient());
		return runChecksTask;
	}

	public ObjectNode getModelCheckDefinitionSetByName(GetModelCheckDefinitionSetByNameInput input) throws BimWorksException {
		ObjectNode objectOutput = getBimWorksClient().executeForObject(input);
		return objectOutput;
	}
	
	public DownloadCheckResultsAsBcfInput downloadCheckResultsAsBcf(UUID uuid) throws BimWorksException {
		DownloadCheckResultsAsBcfInput task = new DownloadCheckResultsAsBcfInput(getBimWorksClient(), uuid);
		task.executeAsync(getBimWorksClient());
		return task;
	}

	public GetModelReportTask getModelReport(Set<UUID> versionUuids) {
		GetModelReportTask getModelReportTask = new GetModelReportTask(versionUuids);
		getModelReportTask.executeAsync(getBimWorksClient());
		return getModelReportTask;
	}
}