package nl.bimbase.bimworks.client;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.bimbase.bimworks.api.checks.ModelCheckOutput;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class GetModelReportTask extends Task<ObjectNode> {

	private Set<UUID> versionUuids;

	public GetModelReportTask(Set<UUID> versionUuids) {
		this.versionUuids = versionUuids;
	}

	@Override
	public Request createRequest() {
		Request request = new Request("BimRepository", "GetModelReport");
		ArrayNode versionsNode = Response.createArray();
		request.set("version_uuids", versionsNode);
		for (UUID versionUuid : versionUuids) {
			versionsNode.add(versionUuid.toString());
		}
		return request;
	}
	
	@Override
	public ObjectNode get() throws InterruptedException, ExecutionException {
		try {
			Response response = getClientTask().await();
			return response.getObjectOutput();
		} catch (ExecuteException e) {
			e.printStackTrace();
		}
		return null;
	}
}
