package nl.bimbase.bimworks.client;

import java.io.OutputStream;
import java.util.UUID;

import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.StreamDescriptor;

public class DownloadCheckResultsAsBcfInput extends Task {
	private UUID checkResultsUuid;
	private BimWorksClient bimWorksClient;

	public DownloadCheckResultsAsBcfInput(BimWorksClient bimWorksClient, UUID checkResultsUuid) {
		this.bimWorksClient = bimWorksClient;
		this.checkResultsUuid = checkResultsUuid;
	}
	
	public UUID getCheckResultsUuid() {
		return checkResultsUuid;
	}
	
	@Override
	public Request createRequest() {
		Request request = new Request();
		request.setTaskName("DownloadCheckResultsAsBcf");
		request.getObjectInput().put("uuid", checkResultsUuid.toString());
		return request;
	}

	public void downloadTo(OutputStream outputStream) {
		try {
			Response response = getClientTask().await();
			for (StreamDescriptor streamDescriptor : response.getAttachedStreams()) {
				bimWorksClient.getApi().getStream(streamDescriptor.getKey(), outputStream);
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (ExecuteException e) {
			e.printStackTrace();
		}
	}
}
