package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * The BimWorksClientFactory is supposed to be a long-lived object. It's main function is to create BimWorksClient objects.
 * One BimWorksClientFactory is required per endpoint.
 *
 */
public class BimWorksClientFactory implements AutoCloseable {
	private final String address;

	public BimWorksClientFactory(String address) {
		this.address = address;
	}
	
	public BimWorksClient createAnonymousClient() throws Exception {
		BimWorksClient bimWorksClient = new BimWorksClient(address);
		bimWorksClient.auth.loginAnonymous();
		return bimWorksClient;
	}
	
	public BimWorksClient createClientWithUsernamePassword(String username, String password) throws Exception {
		BimWorksClient bimWorksClient = new BimWorksClient(address);
		bimWorksClient.auth.loginWithUsernamePassword(username, password);
		return bimWorksClient;
	}

	public BimWorksClient createClientWithApiToken(String apiToken) throws Exception {
		BimWorksClient bimWorksClient = new BimWorksClient(address);
		bimWorksClient.auth.loginWithApiToken(apiToken);
		return bimWorksClient;
	}

	public BimWorksClient createClientWithAuth(ObjectNode auth) throws Exception {
		BimWorksClient bimWorksClient = new BimWorksClient(address);
		bimWorksClient.setAuthToken(auth);
		return bimWorksClient;
	}
	
	public String getAddress() {
		return address;
	}

	@Override
	public void close() throws Exception {
		// Nothing to do for now
	}
}