/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.metrics;

import com.fasterxml.jackson.databind.node.ObjectNode;
import nl.sascom.backplanepublic.common.MetricDefinitionUpdate;
import nl.sascom.backplanepublic.common.MetricType;
import nl.sascom.backplanepublic.common.MetricValueUpdate;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.UpdateInterface;
import nl.sascom.backplanepublic.common.metrics.MetricChild;
import nl.sascom.backplanepublic.common.metrics.MetricParent;
import nl.sascom.backplanepublic.common.metrics.Metrics;
import nl.sascom.backplanepublic.common.metrics.RequestContextInterface;

public abstract class Metric
implements MetricChild {
    private String id;
    private String label;
    private RequestContextInterface requestContext;
    private MetricParent parent;
    private MetricType metricType;

    public Metric(MetricType metricType, RequestContextInterface requestContextInterface, MetricParent metricParent, String string, String string2) {
        this.metricType = metricType;
        this.requestContext = requestContextInterface;
        this.parent = metricParent;
        this.id = string;
        this.label = string2;
    }

    public MetricParent getParent() {
        return this.parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public RequestContextInterface getRequestContext() {
        return this.requestContext;
    }

    public MetricValueUpdate createMetricUpdate(Object object) {
        return new MetricValueUpdate(this.getRequestContext().getId(), this.getPath(), this.getId(), object);
    }

    private String getPath() {
        if (this.parent == null || this.parent instanceof Metrics) {
            return this.id;
        }
        return this.parent.getPath() + "." + this.id;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public UpdateInterface asUpdate() {
        return new MetricDefinitionUpdate(this.id, this.toJson());
    }

    public static Metric fromJson(ObjectNode objectNode) {
        return null;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = Response.createObject();
        objectNode.put("id", this.id);
        objectNode.put("path", this.getPath());
        objectNode.put("label", this.label);
        if (this.parent != null) {
            objectNode.put("order", this.parent.getOrder(this));
        }
        objectNode.put("type", this.metricType.name());
        return objectNode;
    }
}

