/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import nl.sascom.backplanepublic.common.DirectoryInputStream;
import nl.sascom.backplanepublic.common.InputStreamByteSource;
import nl.sascom.backplanepublic.common.NewStream;
import nl.sascom.backplanepublic.common.NewStreamDescriptor;

public class PathBasedStream
extends NewStream {
    private Path path;

    public PathBasedStream(Path path, NewStreamDescriptor newStreamDescriptor) {
        super(newStreamDescriptor);
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public InputStream consumeAsInputStream() throws IOException {
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            return new DirectoryInputStream(this.path);
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public ByteSource getByteSource() {
        try {
            return new InputStreamByteSource(this.consumeAsInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

