/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import nl.sascom.backplanepublic.common.BinaryDataPush;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.UpdateInterface;

public abstract class BinaryUpdate
implements UpdateInterface {
    private String id;
    private boolean debug;
    private String subType;
    private ResponseType responseType;

    public BinaryUpdate(String string, String string2) {
        this.id = string;
        this.subType = string2;
    }

    public BinaryUpdate(String string) {
        this.id = string;
    }

    public BinaryUpdate(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.responseType = ResponseType.valueOf(new String(byArray2, Charsets.UTF_8));
        int n2 = byteBuffer.getInt();
        byte[] byArray3 = new byte[n2];
        byteBuffer.get(byArray3);
        this.subType = new String(byArray3, Charsets.UTF_8);
        int n3 = byteBuffer.getInt();
        byte[] byArray4 = new byte[n3];
        byteBuffer.get(byArray4);
        this.id = new String(byArray4, Charsets.UTF_8);
        int n4 = byteBuffer.getInt();
        byte[] byArray5 = new byte[n4];
        byteBuffer.get(byArray5);
        this.setData(byArray5);
    }

    @Override
    public ResponseType getResponseType() {
        return this.responseType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    public abstract void setData(byte[] var1);

    @Override
    public String getId() {
        return this.id;
    }

    public int getSize() {
        byte[] byArray = this.getResponseType().name().getBytes(Charsets.UTF_8);
        byte[] byArray2 = this.getSubType().getBytes(Charsets.UTF_8);
        byte[] byArray3 = this.getId().getBytes(Charsets.UTF_8);
        return 4 + byArray.length + 4 + byArray2.length + 4 + byArray3.length + 4 + this.getInternalSize();
    }

    public void writeTo(ByteBuffer byteBuffer) {
        byte[] byArray = this.getResponseType().name().getBytes(Charsets.UTF_8);
        byte[] byArray2 = this.getSubType().getBytes(Charsets.UTF_8);
        byte[] byArray3 = this.getId().getBytes(Charsets.UTF_8);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.putInt(byArray2.length);
        byteBuffer.put(byArray2);
        byteBuffer.putInt(byArray3.length);
        byteBuffer.put(byArray3);
        this.writeBytes(byteBuffer);
    }

    public abstract int getInternalSize();

    public abstract void writeBytes(ByteBuffer var1);

    @Override
    public byte[] toMessageBytes() {
        byte[] byArray = this.getResponseType().name().getBytes(Charsets.UTF_8);
        byte[] byArray2 = this.getSubType().getBytes(Charsets.UTF_8);
        byte[] byArray3 = this.getId().getBytes(Charsets.UTF_8);
        byte[] byArray4 = this.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length + 4 + byArray2.length + 4 + byArray3.length + 4 + byArray4.length).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.putInt(byArray2.length);
        byteBuffer.put(byArray2);
        byteBuffer.putInt(byArray3.length);
        byteBuffer.put(byArray3);
        byteBuffer.putInt(byArray4.length);
        byteBuffer.put(byArray4);
        return byteBuffer.array();
    }

    public abstract byte[] getBytes();

    public static UpdateInterface create(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        ResponseType responseType = ResponseType.valueOf(new String(byArray2, Charsets.UTF_8));
        int n2 = byteBuffer.getInt();
        byte[] byArray3 = new byte[n2];
        byteBuffer.get(byArray3);
        String string = new String(byArray3, Charsets.UTF_8);
        int n3 = byteBuffer.getInt();
        byte[] byArray4 = new byte[n3];
        byteBuffer.get(byArray4);
        String string2 = null;
        switch (responseType) {
            case BINARY_DATA_PUSH: {
                return new BinaryDataPush(string, string2, ByteBuffer.wrap(byArray4));
            }
        }
        return null;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

