/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.utils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class HashingUtils {
    public static String extractPartialMd5(InputStream inputStream) throws IOException {
        inputStream.mark(32768);
        byte[] byArray = new byte[32768];
        if (IOUtils.read((InputStream)inputStream, (byte[])byArray) != 32768) {
            inputStream.reset();
            return null;
        }
        inputStream.reset();
        HashFunction hashFunction = Hashing.md5();
        return hashFunction.hashBytes(byArray).toString();
    }

    public static String extractPartialSha256(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (inputStream.markSupported()) {
            inputStream.mark(32768);
        }
        if (IOUtils.read((InputStream)inputStream, (byte[])(byArray = new byte[32768])) != 32768) {
            inputStream.reset();
            return null;
        }
        if (inputStream.markSupported()) {
            inputStream.reset();
        }
        HashFunction hashFunction = Hashing.sha256();
        return hashFunction.hashBytes(byArray).toString();
    }

    public static byte[] extractHead(InputStream inputStream, int n) throws IOException {
        inputStream.mark(n);
        byte[] byArray = new byte[n];
        int n2 = IOUtils.read((InputStream)inputStream, (byte[])byArray);
        if (n2 != n) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        inputStream.reset();
        return byArray;
    }
}

