package nl.bimbase.bimworks.client;

import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplane.appbase.library.DefaultErrorCode;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class TokensApi {

	private final BimWorksClient bimWorksClient;

	public TokensApi(BimWorksClient bimWorksClient) {
		this.bimWorksClient = bimWorksClient;
	}
	
	public ObjectNode createVersionsToken(Set<UUID> versionUuids, Duration duration) throws BimWorksException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("CreateVersionsToken");
		ArrayNode modelsNode = Response.createArray();
		for (UUID versionUuid : versionUuids) {
			modelsNode.add(versionUuid.toString());
		}
		request.getObjectInput().put("expires_seconds", duration.getSeconds());
		request.getObjectInput().set("version_uuids", modelsNode);
		ClientTask task = bimWorksClient.createAsyncTask(request);
		try {
			task.exec();
			Response response = task.await(30, TimeUnit.SECONDS);
			return (ObjectNode) response.getObjectOutput().get("auth");
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		} catch (InterruptedException e) {
			throw new BimWorksException(DefaultErrorCode.INTERRUPTED);
		}
	}

	public ObjectNode createNodesToken(Set<UUID> nodeUuids, Duration duration) throws BimWorksException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("CreateNodesToken");
		ArrayNode nodesNode = Response.createArray();
		for (UUID nodeUuid : nodeUuids) {
			nodesNode.add(nodeUuid.toString());
		}
		request.getObjectInput().put("expires_seconds", duration.getSeconds());
		request.getObjectInput().set("node_uuids", nodesNode);
		ClientTask task = bimWorksClient.createAsyncTask(request);
		try {
			task.exec();
			Response response = task.await(30, TimeUnit.SECONDS);
			return (ObjectNode) response.getObjectOutput().get("auth");
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		} catch (InterruptedException e) {
			throw new BimWorksException(DefaultErrorCode.INTERRUPTED);
		}
	}
}