package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplanepublic.common.Response;

public class FieldQuery {

	private String fieldName;
	private Operator operator;
	private JsonNode value;

	public FieldQuery(String fieldName, Operator operator, JsonNode value) {
		this.fieldName = fieldName;
		this.operator = operator;
		this.value = value;
	}
	
	public Operator getOperator() {
		return operator;
	}
	
	public JsonNode getValue() {
		return value;
	}
	
	public String getFieldName() {
		return fieldName;
	}

	public ObjectNode toJson() {
		ObjectNode objectNode = Response.OBJECT_MAPPER.createObjectNode();
		objectNode.put("name", fieldName);
		objectNode.set("operator", operator.toJson());
		objectNode.set("value", value);
		return objectNode;
	}
}
