/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3.ArraySorter;
import nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3.ArrayUtils;
import nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3.StringUtils;

public class LocaleUtils {
    private static final char UNDERSCORE = '_';
    private static final String UNDETERMINED = "und";
    private static final char DASH = '-';
    private static final ConcurrentMap<String, List<Locale>> cLanguagesByCountry = new ConcurrentHashMap<String, List<Locale>>();
    private static final ConcurrentMap<String, List<Locale>> cCountriesByLanguage = new ConcurrentHashMap<String, List<Locale>>();

    public static List<Locale> availableLocaleList() {
        return SyncAvoid.AVAILABLE_LOCALE_ULIST;
    }

    private static List<Locale> availableLocaleList(Predicate<Locale> predicate) {
        return LocaleUtils.availableLocaleList().stream().filter(predicate).collect(Collectors.toList());
    }

    public static Set<Locale> availableLocaleSet() {
        return SyncAvoid.AVAILABLE_LOCALE_USET;
    }

    public static List<Locale> countriesByLanguage(String languageCode) {
        if (languageCode == null) {
            return Collections.emptyList();
        }
        return cCountriesByLanguage.computeIfAbsent(languageCode, lc -> Collections.unmodifiableList(LocaleUtils.availableLocaleList(locale -> languageCode.equals(locale.getLanguage()) && !LocaleUtils.hasCountry(locale) && LocaleUtils.hasVariant(locale))));
    }

    private static boolean hasCountry(Locale locale) {
        return locale.getCountry().isEmpty();
    }

    private static boolean hasVariant(Locale locale) {
        return locale.getVariant().isEmpty();
    }

    private static boolean isAlpha2Len(String str) {
        return str.length() == 2;
    }

    private static boolean isAlpha3Len(String str) {
        return str.length() == 3;
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleSet().contains(locale);
    }

    private static boolean isISO3166CountryCode(String str) {
        return StringUtils.isAllUpperCase(str) && LocaleUtils.isAlpha2Len(str);
    }

    private static boolean isISO639LanguageCode(String str) {
        return StringUtils.isAllLowerCase(str) && (LocaleUtils.isAlpha2Len(str) || LocaleUtils.isAlpha3Len(str));
    }

    public static boolean isLanguageUndetermined(Locale locale) {
        return locale == null || UNDETERMINED.equals(locale.toLanguageTag());
    }

    private static boolean isNumericAreaCode(String str) {
        return StringUtils.isNumeric(str) && LocaleUtils.isAlpha3Len(str);
    }

    public static List<Locale> languagesByCountry(String countryCode) {
        if (countryCode == null) {
            return Collections.emptyList();
        }
        return cLanguagesByCountry.computeIfAbsent(countryCode, k -> Collections.unmodifiableList(LocaleUtils.availableLocaleList(locale -> countryCode.equals(locale.getCountry()) && LocaleUtils.hasVariant(locale))));
    }

    public static List<Locale> localeLookupList(Locale locale) {
        return LocaleUtils.localeLookupList(locale, locale);
    }

    public static List<Locale> localeLookupList(Locale locale, Locale defaultLocale) {
        ArrayList<Locale> list = new ArrayList<Locale>(4);
        if (locale != null) {
            list.add(locale);
            if (!LocaleUtils.hasVariant(locale)) {
                list.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (!LocaleUtils.hasCountry(locale)) {
                list.add(new Locale(locale.getLanguage(), ""));
            }
            if (!list.contains(defaultLocale)) {
                list.add(defaultLocale);
            }
        }
        return Collections.unmodifiableList(list);
    }

    static Locale ofCountry(String country) {
        return new Locale("", country);
    }

    private static Locale parseLocale(String str) {
        if (LocaleUtils.isISO639LanguageCode(str)) {
            return new Locale(str);
        }
        int limit = 3;
        char separator = str.indexOf(95) != -1 ? (char)'_' : '-';
        String[] segments = str.split(String.valueOf(separator), 3);
        String language = segments[0];
        if (segments.length == 2) {
            String country = segments[1];
            if (LocaleUtils.isISO639LanguageCode(language) && LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) {
                return new Locale(language, country);
            }
        } else if (segments.length == 3) {
            String country = segments[1];
            String variant = segments[2];
            if (LocaleUtils.isISO639LanguageCode(language) && (country.isEmpty() || LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) && !variant.isEmpty()) {
                return new Locale(language, country, variant);
            }
        }
        if (ArrayUtils.contains(Locale.getISOCountries(), str)) {
            return new Locale("", str);
        }
        throw new IllegalArgumentException("Invalid locale format: " + str);
    }

    public static Locale toLocale(Locale locale) {
        return locale != null ? locale : Locale.getDefault();
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new Locale("", "");
        }
        if (str.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        int len = str.length();
        if (len < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch0 = str.charAt(0);
        if (ch0 == '_' || ch0 == '-') {
            if (len < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            char ch1 = str.charAt(1);
            char ch2 = str.charAt(2);
            if (!Character.isUpperCase(ch1) || !Character.isUpperCase(ch2)) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (len == 3) {
                return new Locale("", str.substring(1, 3));
            }
            if (len < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (str.charAt(3) != ch0) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            return new Locale("", str.substring(1, 3), str.substring(4));
        }
        return LocaleUtils.parseLocale(str);
    }

    @Deprecated
    public LocaleUtils() {
    }

    private static final class SyncAvoid {
        private static final List<Locale> AVAILABLE_LOCALE_ULIST = Collections.unmodifiableList(Arrays.asList(ArraySorter.sort(Locale.getAvailableLocales(), Comparator.comparing(Locale::toString))));
        private static final Set<Locale> AVAILABLE_LOCALE_USET = Collections.unmodifiableSet(new LinkedHashSet<Locale>(AVAILABLE_LOCALE_ULIST));

        private SyncAvoid() {
        }
    }
}

