/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.parse;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.utils.Normalize;

public final class EvilManualUseragentStringHacks {
    private static final Pattern MISSING_SPACE = Pattern.compile("(/\\d+\\.\\d+)([A-Z][a-z][a-z][a-z]+ )");
    private static final Pattern MULTIPLE_SPACES = Pattern.compile(" {2,}");
    private static final Pattern AVOID_BASE64_MATCH = Pattern.compile("(android/\\d+)(/)", 2);
    private static final Pattern ANDROID_DASH_VERSION = Pattern.compile("(android)-(\\d+)", 2);
    private static final Pattern PROPERTY_PRODUCT_VERSION_FIX = Pattern.compile("(NetType|Language|AppName|app_version|ByteLocale|ByteFullLocale|Region)/([\\da-z._-]+)", 2);
    private static final Pattern GLUED_VERSION_FIX = Pattern.compile("(Java|Wazzup)(\\d)", 2);
    private static final Pattern GLUED_VERSION_FIX_2 = Pattern.compile("(OS|[a-z][a-z_][a-z_][a-z_]+[a-z])_([\\d_.]+) ", 2);
    private static final Pattern MISSING_COMMENT_BRACES = Pattern.compile("^(Mozilla/[^ ]+) ([^(][^)]+?)( Gecko/| AppleWebKit/| Safari/| Mobile Safari/)", 2);
    private static final Pattern MISSING_COMMENT_BRACES_OPERA = Pattern.compile("^(Opera/[^ ]+) ([^(][^)]+?)( Presto/| Version/)", 2);
    private static final Pattern STRIP_SURROUNDING_QUOTES = Pattern.compile("^'(.*)'$", 2);
    private static final Pattern STRIP_PIPESYMBOLS = Pattern.compile("([a-z0-9])\\|([a-z0-9])", 2);
    private static final Pattern STRIP_BASE64_BLOCK = Pattern.compile(" H@(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)@h ");
    private static final Pattern PICO_OS_TAG = Pattern.compile("(Pico [a-zA-Z0-9 ._-]+ OS)", 2);
    private static final Pattern ADD_PRODUCT_SPACES = Pattern.compile("(\\d+)([a-zA-Z][a-zA-Z]+/)");
    private static final Pattern ADD_PRODUCT_SPACES_SAFARI = Pattern.compile("Safari/(\\d\\d\\d.\\d\\d)(\\D)");

    private EvilManualUseragentStringHacks() {
    }

    public static String fixIt(UserAgent.MutableUserAgent mutableUserAgent) {
        if (mutableUserAgent == null) {
            return null;
        }
        String useragent = mutableUserAgent.getUserAgentString();
        if (useragent == null || useragent.isEmpty()) {
            return useragent;
        }
        Object result = useragent;
        if (((String)result).indexOf(37) != -1 && (((String)result).contains("%20") || ((String)result).contains("%3B") || ((String)result).contains("%25") || ((String)result).contains("%2F") || ((String)result).contains("%28"))) {
            try {
                result = URLDecoder.decode((String)result, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        result = Normalize.replaceString((String)result, "\\/", "/");
        result = EvilManualUseragentStringHacks.handleNoSpacesUserAgents(mutableUserAgent, (String)result);
        result = MULTIPLE_SPACES.matcher((CharSequence)result).replaceAll(" ");
        if (((String)(result = Normalize.replaceString((String)result, "\u2002", " "))).charAt(0) == ' ') {
            result = ((String)result).trim();
        }
        result = STRIP_SURROUNDING_QUOTES.matcher((CharSequence)result).replaceAll("$1");
        result = MISSING_COMMENT_BRACES.matcher((CharSequence)result).replaceAll("$1 ($2)$3");
        result = MISSING_COMMENT_BRACES_OPERA.matcher((CharSequence)result).replaceAll("$1 ($2)$3");
        result = STRIP_BASE64_BLOCK.matcher((CharSequence)result).replaceAll(" ");
        result = Normalize.replaceString((String)result, "Channel/App Store", "()Channel/App Store()");
        if (((String)(result = PROPERTY_PRODUCT_VERSION_FIX.matcher((CharSequence)result).replaceAll("() $1/$2()"))).startsWith("()")) {
            result = ((String)result).substring(2).trim();
        }
        if (((String)result).contains("|")) {
            result = STRIP_PIPESYMBOLS.matcher((CharSequence)result).replaceAll("$1/$2");
        }
        result = Normalize.replaceString((String)result, "SSL/TLS", "SSL TLS");
        if (((String)(result = Normalize.replaceString((String)result, "QwantMobile", " QwantMobile"))).contains("MSIE")) {
            result = Normalize.replaceString((String)result, "MSIE7", "MSIE 7");
            result = Normalize.replaceString((String)result, "MSIE8", "MSIE 8");
            result = Normalize.replaceString((String)result, "MSIE9", "MSIE 9");
        }
        result = Normalize.replaceString((String)result, "MSOffice", "MS-Office");
        result = Normalize.replaceString((String)result, "Ant.com Toolbar", "Ant.com_Toolbar");
        result = ANDROID_DASH_VERSION.matcher((CharSequence)result).replaceAll("$1 $2");
        result = MISSING_SPACE.matcher((CharSequence)result).replaceAll("$1 $2");
        result = AVOID_BASE64_MATCH.matcher((CharSequence)result).replaceAll("$1 $2");
        result = GLUED_VERSION_FIX.matcher((CharSequence)result).replaceAll("$1 $2");
        result = GLUED_VERSION_FIX_2.matcher((CharSequence)result).replaceAll("$1 $2 ");
        result = Normalize.replaceString((String)result, " (Macintosh); ", " (Macintosh; ");
        result = Normalize.replaceString((String)result, "Microsoft Windows NT 6.2.9200.0);", "Microsoft Windows NT 6.2.9200.0;");
        result = Normalize.replaceString((String)result, "You Build/VM", "You Build/VM)");
        result = Normalize.replaceString((String)result, "(/", "(Unknown/");
        result = Normalize.replaceString((String)result, "; /", "; Unknown/");
        char firstChar = ((String)(result = Normalize.replaceString((String)result, ", _TV_", " _TV_"))).charAt(0);
        if (firstChar == '(' || firstChar == '[') {
            result = "FakeYauaaProduct/3.14 " + (String)result;
        } else if (firstChar == '/') {
            result = "FakeYauaaProduct" + (String)result;
        }
        result = Normalize.replaceString((String)result, ",gzip(gfe)", "");
        result = Normalize.replaceString((String)result, "__", " ");
        result = PICO_OS_TAG.matcher((CharSequence)result).replaceAll("$1 ");
        return result;
    }

    private static String handleNoSpacesUserAgents(UserAgent.MutableUserAgent mutableUserAgent, String userAgent) {
        if (userAgent == null || userAgent.length() < 50) {
            return userAgent;
        }
        if (userAgent.indexOf(32) >= 0) {
            return userAgent;
        }
        mutableUserAgent.set("RemarkablePattern", "Long useragent without any spaces", 1L);
        String result = userAgent;
        result = ADD_PRODUCT_SPACES_SAFARI.matcher(result).replaceAll(" Safari/$1 $2");
        result = Normalize.replaceString(result, "Build/", " Build/");
        result = Normalize.replaceString(result, "Mobile", " Mobile ");
        result = Normalize.replaceString(result, "Safari", " Safari ");
        result = Normalize.replaceString(result, "Android", " Android ");
        result = Normalize.replaceString(result, "Linux", " Linux ");
        result = Normalize.replaceString(result, "WindowsNT", " Windows NT ");
        result = Normalize.replaceString(result, "Instagram", " Instagram ");
        result = Normalize.replaceString(result, "IntelMacOSX", " Intel Mac OS X ");
        result = Normalize.replaceString(result, "likeMacOSX", " like Mac OS X ");
        result = Normalize.replaceString(result, "CPUOS", " CPU OS ");
        result = Normalize.replaceString(result, "CPUiPhoneOS", " CPU iPhone OS ");
        result = Normalize.replaceString(result, "CPUiPadOS", " CPU iPad OS ");
        result = Normalize.replaceString(result, "x86_64", " x86_64 ");
        result = Normalize.replaceString(result, "i686", " i686 ");
        result = Normalize.replaceString(result, "KHTML,likeGecko", " KHTML, like Gecko ");
        result = ADD_PRODUCT_SPACES.matcher(result).replaceAll("$1 $2");
        result = ADD_PRODUCT_SPACES.matcher(result).replaceAll("$1 $2");
        result = ADD_PRODUCT_SPACES.matcher(result).replaceAll("$1 $2");
        result = ADD_PRODUCT_SPACES.matcher(result).replaceAll("$1 $2");
        result = ADD_PRODUCT_SPACES.matcher(result).replaceAll("$1 $2");
        result = ADD_PRODUCT_SPACES.matcher(result).replaceAll("$1 $2");
        return result;
    }
}

