/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import nl.basjes.parse.useragent.PackagedRules;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.config.AnalyzerConfig;
import nl.basjes.parse.useragent.config.MatcherConfig;
import nl.basjes.parse.useragent.config.TestCase;
import nl.basjes.parse.useragent.utils.YamlUtils;
import nl.basjes.parse.useragent.utils.YauaaVersion;
import nl.basjes.parse.useragent.utils.springframework.core.io.Resource;
import nl.basjes.parse.useragent.utils.springframework.core.io.support.PathMatchingResourcePatternResolver;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.LoaderOptions;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.Yaml;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.Node;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.reader.UnicodeReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    private static final Logger LOG = LogManager.getLogger(ConfigLoader.class);
    public static final String DEFAULT_RESOURCES = "classpath*:UserAgents/**/*.yaml";
    private boolean doingOnlyASingleTest = false;
    private final List<String> mandatoryResources;
    private final List<String> optionalResources;
    private final AnalyzerConfig.AnalyzerConfigBuilder analyzerConfig;
    private final Map<String, String> yamlRules;
    private boolean keepTests = true;
    final boolean showLoading;

    public ConfigLoader(boolean showLoading) {
        this.showLoading = showLoading;
        this.mandatoryResources = new ArrayList<String>();
        this.optionalResources = new ArrayList<String>();
        this.yamlRules = new LinkedHashMap<String, String>();
        this.analyzerConfig = AnalyzerConfig.newBuilder();
    }

    public ConfigLoader addResource(List<String> resourceNames, boolean optionalResource) {
        resourceNames.forEach(resource -> this.addResource((String)resource, optionalResource));
        return this;
    }

    public ConfigLoader addResource(String resourceName, boolean optionalResource) {
        if (resourceName == null) {
            throw new InvalidParserConfigurationException("The provided resource name was null.");
        }
        if (resourceName.trim().isEmpty()) {
            throw new InvalidParserConfigurationException("The provided resource name was empty.");
        }
        if (optionalResource) {
            this.optionalResources.add(resourceName);
        } else {
            this.mandatoryResources.add(resourceName);
        }
        return this;
    }

    public ConfigLoader addYaml(String configString, String filename) {
        this.yamlRules.put(filename, configString);
        return this;
    }

    public ConfigLoader keepTests(boolean doWeKeepThem) {
        this.keepTests = doWeKeepThem;
        return this;
    }

    public ConfigLoader keepTests() {
        this.keepTests = true;
        return this;
    }

    public ConfigLoader dropTests() {
        this.keepTests = false;
        return this;
    }

    public AnalyzerConfig load() {
        this.mandatoryResources.forEach(resourceString -> this.loadResources((String)resourceString, this.showLoading, false));
        this.optionalResources.forEach(resourceString -> this.loadResources((String)resourceString, this.showLoading, true));
        Yaml yaml = this.createYaml();
        this.yamlRules.forEach((filename, yamlString) -> this.loadYaml(yaml, new ByteArrayInputStream(yamlString.getBytes(StandardCharsets.UTF_8)), (String)filename));
        return this.analyzerConfig.build();
    }

    public void loadResources(String resourceString, boolean showLoadMessages, boolean areOptional) {
        long startFiles = System.nanoTime();
        boolean loadingDefaultResources = DEFAULT_RESOURCES.equals(resourceString);
        Map<String, Resource> resources = this.findAllResources(resourceString, showLoadMessages, areOptional, loadingDefaultResources);
        this.doingOnlyASingleTest = false;
        if (!resources.isEmpty()) {
            Resource resource = resources.entrySet().iterator().next().getValue();
            try (InputStream inputStream = resource.getInputStream();){
                LOG.debug("Opening the resource worked ({} has approximately {} bytes)", (Object)resource.getURL(), (Object)inputStream.available());
            }
            catch (IOException e) {
                LOG.error("Cannot load the resources (usually classloading problem).");
                LOG.error("- Resource   : {}", (Object)resource);
                LOG.error("- Filename   : {}", (Object)resource.getFilename());
                LOG.error("- Description: {}", (Object)resource.getDescription());
                if (loadingDefaultResources) {
                    LOG.warn("Falling back to the built in list of resources");
                    resources.clear();
                }
                LOG.error("FATAL: Unable to load the specified resources for {}", (Object)resourceString);
                throw new InvalidParserConfigurationException("Error reading resources (" + resourceString + "): " + e.getMessage(), e);
            }
        }
        if (resources.isEmpty()) {
            if (areOptional) {
                LOG.warn("NO optional resources were loaded from expression: {}", (Object)resourceString);
            } else {
                LOG.error("NO config files were found matching this expression: {}", (Object)resourceString);
                if (loadingDefaultResources) {
                    LOG.warn("Unable to load the default resources, usually caused by classloader problems.");
                    LOG.warn("Retrying with built in list.");
                    PackagedRules.getRuleFileNames().forEach(s -> this.loadResources((String)s, false, false));
                } else {
                    LOG.warn("If you are using wildcards in your expression then try explicitly naming all yamls files explicitly.");
                    throw new InvalidParserConfigurationException("There were no resources found for the expression: " + resourceString);
                }
            }
            return;
        }
        if (!this.keepTests && (resources = resources.entrySet().stream().filter(entry -> {
            Resource resource = (Resource)entry.getValue();
            if (ConfigLoader.isTestRulesOnlyFile(resource.getFilename())) {
                if (showLoadMessages) {
                    try {
                        LOG.info("- Skipping tests only file {} ({} bytes)", (Object)resource.getFilename(), (Object)resource.contentLength());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            return;
        }
        Set resourceBasenames = resources.keySet().stream().map(k -> k.replaceAll("^.*/", "")).collect(Collectors.toSet());
        Set alreadyLoadedResourceBasenames = this.yamlRules.keySet().stream().map(k -> k.replaceAll("^.*/", "")).collect(Collectors.toSet());
        alreadyLoadedResourceBasenames.retainAll(resourceBasenames);
        if (!alreadyLoadedResourceBasenames.isEmpty()) {
            LOG.error("Trying to load these {} resources for the second time: {}", (Object)alreadyLoadedResourceBasenames.size(), alreadyLoadedResourceBasenames);
            throw new InvalidParserConfigurationException("Trying to load " + alreadyLoadedResourceBasenames.size() + " resources for the second time");
        }
        for (Map.Entry<String, Resource> resourceEntry : resources.entrySet()) {
            try {
                String yamlString;
                Resource resource = resourceEntry.getValue();
                String filename = resource.getFilename();
                if (filename == null) continue;
                try (InputStreamReader inputStreamReader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    yamlString = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
                this.yamlRules.put(filename, yamlString);
            }
            catch (IOException e) {
                throw new InvalidParserConfigurationException("Error reading resources: " + e.getMessage(), e);
            }
        }
        long stopFiles = System.nanoTime();
        try (Formatter msg = new Formatter(Locale.ENGLISH);){
            msg.format("- Loaded %2d files in %4d ms using expression: %s", resources.size(), (stopFiles - startFiles) / 1000000L, resourceString);
            LOG.info("{}", (Object)msg);
        }
    }

    private Map<String, Resource> findAllResources(String resourceString, boolean showLoadMessages, boolean areOptional, boolean loadingDefaultResources) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
        TreeMap<String, Resource> resources = new TreeMap<String, Resource>();
        try {
            Resource[] resourceArray = resolver.getResources(resourceString);
            if (!loadingDefaultResources && showLoadMessages) {
                LOG.info("Loading {} rule files using expression: {}", (Object)resourceArray.length, (Object)resourceString);
            }
            for (Resource resource : resourceArray) {
                if (!loadingDefaultResources && showLoadMessages) {
                    LOG.info("- Preparing {} ({} bytes)", (Object)resource.getFilename(), (Object)resource.contentLength());
                }
                resources.put(resource.getFilename(), resource);
            }
        }
        catch (IOException e) {
            if (areOptional) {
                LOG.error("The specified (optional) resource string is invalid: {}", (Object)resourceString);
                return Collections.emptyMap();
            }
            throw new InvalidParserConfigurationException("Error reading resources: " + e.getMessage(), e);
        }
        return resources;
    }

    public static boolean isTestRulesOnlyFile(String filename) {
        if (filename == null) {
            return false;
        }
        return filename.contains("-tests") || filename.contains("-Tests");
    }

    private Yaml createYaml() {
        LoaderOptions yamlLoaderOptions = new LoaderOptions();
        yamlLoaderOptions.setMaxAliasesForCollections(200);
        return new Yaml(yamlLoaderOptions);
    }

    private synchronized void loadYaml(Yaml yaml, InputStream yamlStream, String filename) {
        Node loadedYaml;
        try {
            loadedYaml = yaml.compose(new UnicodeReader(yamlStream));
        }
        catch (Exception e) {
            throw new InvalidParserConfigurationException("Parse error in the file " + filename + ": " + e.getMessage(), e);
        }
        if (loadedYaml == null) {
            LOG.warn("The file {} is empty", (Object)filename);
            return;
        }
        YamlUtils.requireNodeInstanceOf(MappingNode.class, loadedYaml, filename, "File must be a Map");
        MappingNode rootNode = (MappingNode)loadedYaml;
        NodeTuple configNodeTuple = null;
        for (NodeTuple tuple : rootNode.getValue()) {
            String name = YamlUtils.getKeyAsString(tuple, filename);
            if ("config".equals(name)) {
                configNodeTuple = tuple;
                break;
            }
            if (!"version".equals(name)) continue;
            YauaaVersion.assertSameVersion(tuple, filename);
            return;
        }
        YamlUtils.require(configNodeTuple != null, loadedYaml, filename, "The top level entry MUST be 'config'.");
        SequenceNode configNode = YamlUtils.getValueAsSequenceNode(configNodeTuple, filename);
        List<Node> configList = configNode.getValue();
        block15: for (Node configEntry : configList) {
            String entryType;
            YamlUtils.requireNodeInstanceOf(MappingNode.class, configEntry, filename, "The entry MUST be a mapping");
            NodeTuple entry = YamlUtils.getExactlyOneNodeTuple((MappingNode)configEntry, filename);
            MappingNode actualEntry = YamlUtils.getValueAsMappingNode(entry, filename);
            switch (entryType = YamlUtils.getKeyAsString(entry, filename)) {
                case "lookup": {
                    this.loadYamlLookup(actualEntry, filename);
                    continue block15;
                }
                case "set": {
                    this.loadYamlLookupSets(actualEntry, filename);
                    continue block15;
                }
                case "matcher": {
                    this.loadYamlMatcher(actualEntry, filename);
                    continue block15;
                }
                case "test": {
                    if (!this.keepTests) continue block15;
                    this.loadYamlTestcase(actualEntry, filename);
                    continue block15;
                }
            }
            throw new InvalidParserConfigurationException("Yaml config.(" + filename + ":" + actualEntry.getStartMark().getLine() + "): Found unexpected config entry: " + entryType + ", allowed are 'lookup', 'set', 'matcher' and 'test'");
        }
    }

    private void loadYamlLookup(MappingNode entry, String filename) {
        String name = null;
        HashMap<String, String> map = new HashMap<String, String>();
        LinkedHashSet<String> merge = new LinkedHashSet<String>();
        block10: for (NodeTuple tuple : entry.getValue()) {
            switch (YamlUtils.getKeyAsString(tuple, filename)) {
                case "name": {
                    name = YamlUtils.getValueAsString(tuple, filename);
                    break;
                }
                case "merge": {
                    merge.addAll(YamlUtils.getStringValues(YamlUtils.getValueAsSequenceNode(tuple, filename), filename));
                    break;
                }
                case "map": {
                    List<NodeTuple> mappings = YamlUtils.getValueAsMappingNode(tuple, filename).getValue();
                    for (NodeTuple mapping : mappings) {
                        String key = YamlUtils.getKeyAsString(mapping, filename);
                        String value = YamlUtils.getValueAsString(mapping, filename);
                        if (map.containsKey(key)) {
                            throw new InvalidParserConfigurationException("In the lookup \"" + name + "\" the key \"" + key + "\" appears multiple times.");
                        }
                        map.put(key, value);
                    }
                    continue block10;
                }
            }
        }
        YamlUtils.require(name != null && (!map.isEmpty() || !merge.isEmpty()), entry, filename, "Invalid lookup specified");
        if (!merge.isEmpty()) {
            this.analyzerConfig.putLookupMerges(name, merge);
        }
        this.analyzerConfig.putLookup(name, map);
    }

    private void loadYamlLookupSets(MappingNode entry, String filename) {
        String name = null;
        LinkedHashSet<String> lookupSet = new LinkedHashSet<String>();
        LinkedHashSet<String> merge = new LinkedHashSet<String>();
        block10: for (NodeTuple tuple : entry.getValue()) {
            switch (YamlUtils.getKeyAsString(tuple, filename)) {
                case "name": {
                    name = YamlUtils.getValueAsString(tuple, filename);
                    break;
                }
                case "merge": {
                    merge.addAll(YamlUtils.getStringValues(YamlUtils.getValueAsSequenceNode(tuple, filename), filename));
                    break;
                }
                case "values": {
                    SequenceNode node = YamlUtils.getValueAsSequenceNode(tuple, filename);
                    for (String value : YamlUtils.getStringValues(node, filename)) {
                        lookupSet.add(value.toLowerCase(Locale.ROOT));
                    }
                    continue block10;
                }
            }
        }
        YamlUtils.require(name != null && (!lookupSet.isEmpty() || !merge.isEmpty()), entry, filename, "Invalid lookup specified");
        if (!merge.isEmpty()) {
            this.analyzerConfig.putLookupSetsMerges(name, merge);
        }
        this.analyzerConfig.putLookupSets(name, lookupSet);
    }

    private void loadYamlMatcher(MappingNode entry, String filename) {
        int matcherSourceLineNumber = entry.getStartMark().getLine();
        String matcherSourceLocation = filename + ":" + matcherSourceLineNumber;
        ArrayList<MatcherConfig.ConfigLine> configLines = new ArrayList<MatcherConfig.ConfigLine>(16);
        List<String> options = null;
        block12: for (NodeTuple nodeTuple : entry.getValue()) {
            String name;
            switch (name = YamlUtils.getKeyAsString(nodeTuple, matcherSourceLocation)) {
                case "options": {
                    options = YamlUtils.getStringValues(nodeTuple.getValueNode(), matcherSourceLocation);
                    break;
                }
                case "variable": {
                    String[] configParts;
                    for (String variableConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), matcherSourceLocation)) {
                        configParts = variableConfig.split(":", 2);
                        if (configParts.length != 2) {
                            throw new InvalidParserConfigurationException("Invalid variable config line: " + variableConfig);
                        }
                        String variableName = configParts[0].trim();
                        String config = configParts[1].trim();
                        configLines.add(new MatcherConfig.ConfigLine(MatcherConfig.ConfigLine.Type.VARIABLE, variableName, null, config));
                    }
                    continue block12;
                }
                case "require": {
                    for (String requireConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), matcherSourceLocation)) {
                        if ((requireConfig = requireConfig.trim()).startsWith("IsNull[")) {
                            String failIfFoundConfig = requireConfig.replaceAll("^IsNull\\[", "").replaceAll("]$", "");
                            configLines.add(new MatcherConfig.ConfigLine(MatcherConfig.ConfigLine.Type.FAIL_IF_FOUND, null, null, failIfFoundConfig));
                            continue;
                        }
                        configLines.add(new MatcherConfig.ConfigLine(MatcherConfig.ConfigLine.Type.REQUIRE, null, null, requireConfig));
                    }
                    continue block12;
                }
                case "extract": {
                    String[] configParts;
                    for (String extractConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), matcherSourceLocation)) {
                        configParts = extractConfig.split(":", 3);
                        if (configParts.length != 3) {
                            throw new InvalidParserConfigurationException("Invalid extract config line: " + extractConfig);
                        }
                        String attribute = configParts[0].trim();
                        Long confidence = Long.parseLong(configParts[1].trim());
                        String config = configParts[2].trim();
                        configLines.add(new MatcherConfig.ConfigLine(MatcherConfig.ConfigLine.Type.EXTRACT, attribute, confidence, config));
                    }
                    continue block12;
                }
            }
        }
        this.analyzerConfig.addMatcherConfigs(matcherSourceLocation, new MatcherConfig(filename, matcherSourceLineNumber, options, configLines));
    }

    private void loadYamlTestcase(MappingNode entry, String filename) {
        if (!this.doingOnlyASingleTest) {
            String testName = null;
            List<String> options = null;
            LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            block21: for (NodeTuple tuple : entry.getValue()) {
                String name;
                switch (name = YamlUtils.getKeyAsString(tuple, filename)) {
                    case "name": {
                        testName = YamlUtils.getValueAsString(tuple, filename);
                        break;
                    }
                    case "options": {
                        options = YamlUtils.getStringValues(tuple.getValueNode(), filename);
                        if (!options.contains("only")) break;
                        this.doingOnlyASingleTest = true;
                        this.analyzerConfig.clearAllTestCases();
                        break;
                    }
                    case "input": {
                        block22: for (NodeTuple inputTuple : YamlUtils.getValueAsMappingNode(tuple, filename).getValue()) {
                            String inputName;
                            switch (inputName = YamlUtils.getKeyAsString(inputTuple, filename)) {
                                case "user_agent_string": 
                                case "User-Agent": {
                                    headers.put("User-Agent", YamlUtils.getValueAsString(inputTuple, filename));
                                    continue block22;
                                }
                                case "name": {
                                    LOG.fatal("FOUND TEST NAME IN INPUT SECTION {}", (Object)filename);
                                    testName = YamlUtils.getValueAsString(inputTuple, filename);
                                    continue block22;
                                }
                            }
                            headers.put(inputName, YamlUtils.getValueAsString(inputTuple, filename));
                        }
                        continue block21;
                    }
                    case "expected": {
                        List<NodeTuple> mappings = YamlUtils.getValueAsMappingNode(tuple, filename).getValue();
                        for (NodeTuple mapping : mappings) {
                            String key = YamlUtils.getKeyAsString(mapping, filename);
                            String value = YamlUtils.getValueAsString(mapping, filename);
                            expected.put(key, value);
                        }
                        continue block21;
                    }
                }
            }
            String lowercaseUseragentHeader = "User-Agent".toLowerCase(Locale.ROOT);
            YamlUtils.require(headers.keySet().stream().map(String::toLowerCase).filter(lowercaseUseragentHeader::equals).count() == 1L, entry, filename, "Test is missing input");
            if (testName == null) {
                testName = (String)headers.get("User-Agent");
            }
            int testSourceLineNumber = entry.getStartMark().getLine();
            String testSourceLocation = filename + ":" + testSourceLineNumber;
            TestCase testCase = new TestCase(headers, testSourceLocation, testName);
            if (!expected.isEmpty()) {
                expected.forEach(testCase::expect);
            }
            if (options != null) {
                for (String option : options) {
                    testCase.addOption(option);
                }
            }
            testCase.addMetadata("filename", filename);
            testCase.addMetadata("fileline", String.valueOf(entry.getStartMark().getLine()));
            this.analyzerConfig.addTestCase(testCase);
        }
    }
}

