/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.VersionSplitter;

public class MacOSXMajorVersionCalculator
extends FieldCalculator {
    private String versionName;
    private String majorVersionName;

    public MacOSXMajorVersionCalculator(String majorVersionName, String versionName) {
        this.majorVersionName = majorVersionName;
        this.versionName = versionName;
    }

    private MacOSXMajorVersionCalculator() {
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        if (!userAgent.get("OperatingSystemName").getValue().equals("Mac OS")) {
            return;
        }
        AgentField.MutableAgentField agentVersionMajor = userAgent.get(this.majorVersionName);
        if (agentVersionMajor.isDefaultValue()) {
            AgentField.MutableAgentField agentVersion = userAgent.get(this.versionName);
            String version = "<<<null>>>";
            if (!agentVersion.isDefaultValue()) {
                String value = agentVersion.getValue();
                if (value == null || !value.contains("10.")) {
                    return;
                }
                version = VersionSplitter.getInstance().getFirstSplits(value, 2);
            }
            userAgent.setForced(this.majorVersionName, version, agentVersion.getConfidence());
        }
    }

    @Override
    public String getCalculatedFieldName() {
        return this.majorVersionName;
    }

    @Override
    public Set<String> getDependencies() {
        TreeSet<String> dependencies = new TreeSet<String>();
        dependencies.add(this.versionName);
        dependencies.add("OperatingSystemName");
        return dependencies;
    }

    @Override
    public String toString() {
        return "Calculate MacOSX Major Version" + this.versionName + " --> " + this.majorVersionName;
    }
}

