/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.MatchMaker;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherList;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.calculate.CalculateAgentClass;
import nl.basjes.parse.useragent.calculate.CalculateAgentEmail;
import nl.basjes.parse.useragent.calculate.CalculateAgentName;
import nl.basjes.parse.useragent.calculate.CalculateDeviceBrand;
import nl.basjes.parse.useragent.calculate.CalculateDeviceName;
import nl.basjes.parse.useragent.calculate.CalculateNetworkType;
import nl.basjes.parse.useragent.calculate.ConcatNONDuplicatedCalculator;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.calculate.MacOSXMajorVersionCalculator;
import nl.basjes.parse.useragent.calculate.MajorVersionCalculator;
import nl.basjes.parse.useragent.calculate.VersionCleanupCalculator;
import nl.basjes.parse.useragent.clienthints.ClientHintsAnalyzer;
import nl.basjes.parse.useragent.config.AnalyzerConfig;
import nl.basjes.parse.useragent.config.AnalyzerConfigHolder;
import nl.basjes.parse.useragent.config.ConfigLoader;
import nl.basjes.parse.useragent.config.MatcherConfig;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import nl.basjes.parse.useragent.utils.KryoConfig;
import nl.basjes.parse.useragent.utils.YauaaVersion;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DefaultSerializer(value=KryoSerializer.class)
public class UserAgentStringMatchMaker
implements MatchMaker,
AnalyzerConfigHolder,
Serializable {
    private static final int INFORM_ACTIONS_HASHMAP_CAPACITY = 1000000;
    private static final Logger LOG = LogManager.getLogger(UserAgentStringMatchMaker.class);
    private final ArrayList<Matcher> allMatchers = new ArrayList(5000);
    private final ArrayList<Matcher> zeroInputMatchers = new ArrayList(100);
    private final Map<String, Set<MatcherAction>> informMatcherActions = new LinkedHashMap<String, Set<MatcherAction>>(1000000);
    private boolean showMatcherStats;
    protected Set<String> wantedFieldNames = null;
    protected UserAgentTreeFlattener flattener;
    public static final int DEFAULT_USER_AGENT_MAX_LENGTH = 2048;
    private int userAgentMaxLength = 2048;
    private AnalyzerConfig config;
    private boolean delayInitialization;
    private boolean matchersHaveBeenInitialized = false;
    private volatile transient Set<String> allPossibleFieldNamesCache = null;
    private volatile transient List<String> allPossibleFieldNamesSortedCache = null;
    private final Map<String, Set<WordRangeVisitor.Range>> informMatcherActionRanges = new HashMap<String, Set<WordRangeVisitor.Range>>(10000);
    public static final int MAX_PREFIX_HASH_MATCH = 3;
    private final Map<String, Set<Integer>> informMatcherActionPrefixesLengths = new HashMap<String, Set<Integer>>(1000);
    private boolean verbose = false;
    private transient MatcherList touchedMatchers = new MatcherList(32);
    private static final List<String> CORE_SYSTEM_GENERATED_FIELDS = new ArrayList<String>();
    private final List<FieldCalculator> fieldCalculators = new ArrayList<FieldCalculator>();
    private final Set<String> allFieldsForWhichACalculatorExists = new HashSet<String>();
    private final Set<String> dependenciesNeededByCalculators = new HashSet<String>();

    public List<Matcher> getAllMatchers() {
        return this.allMatchers;
    }

    public MatcherList getTouchedMatchers() {
        return this.touchedMatchers;
    }

    @Override
    @Nonnull
    public AnalyzerConfig getConfig() {
        return this.config;
    }

    void addAnalyzerConfig(AnalyzerConfig analyzerConfig) {
        if (this.config == null) {
            this.config = analyzerConfig;
        } else {
            this.config.merge(analyzerConfig);
        }
    }

    private UserAgentStringMatchMaker() {
        this.initTransientFields();
    }

    void initTransientFields() {
        this.touchedMatchers = new MatcherList(32);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.initTransientFields();
        stream.defaultReadObject();
        this.showDeserializationStats();
    }

    public static void configureKryo(Object kryo) {
        KryoConfig.configureKryo((Kryo)kryo);
    }

    private void showDeserializationStats() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("This Analyzer instance was deserialized.");
        lines.add("");
        lines.add("Lookups      : " + this.getLookups().size());
        lines.add("LookupSets   : " + this.getLookupSets().size());
        lines.add("Matchers     : " + this.allMatchers.size());
        lines.add("Hashmap size : " + this.informMatcherActions.size());
        lines.add("Ranges map   : " + this.informMatcherActionRanges.size());
        lines.add("Testcases    : " + this.getTestCases().size());
        YauaaVersion.logVersion(lines);
    }

    public synchronized void destroy() {
        this.allMatchers.forEach(Matcher::destroy);
        this.allMatchers.clear();
        this.allMatchers.trimToSize();
        this.zeroInputMatchers.forEach(Matcher::destroy);
        this.zeroInputMatchers.clear();
        this.zeroInputMatchers.trimToSize();
        this.informMatcherActions.clear();
        this.config = null;
        if (this.wantedFieldNames != null) {
            this.wantedFieldNames.clear();
        }
        this.flattener.clear();
        this.invalidateCaches();
    }

    private void invalidateCaches() {
        this.allPossibleFieldNamesCache = null;
        this.allPossibleFieldNamesSortedCache = null;
    }

    public void loadResources(String resourceString) {
        this.loadResources(resourceString, this.showMatcherStats, false);
    }

    public void loadResources(String resourceString, boolean showLoadMessages, boolean optionalResources) {
        if (this.matchersHaveBeenInitialized) {
            throw new IllegalStateException("Refusing to load additional resources after the datastructures have been initialized.");
        }
        AnalyzerConfig extraConfig = new ConfigLoader(showLoadMessages).addResource(resourceString, optionalResources).load();
        this.addAnalyzerConfig(extraConfig);
        this.invalidateCaches();
        this.finalizeLoadingRules();
    }

    public void finalizeLoadingRules() {
        this.flattener = new UserAgentTreeFlattener(this);
        if (this.wantedFieldNames != null) {
            int wantedSize = this.wantedFieldNames.size();
            if (this.wantedFieldNames.contains("__Set_ALL_Fields__")) {
                --wantedSize;
            }
            LOG.info("Building all needed matchers for the requested {} fields.", (Object)wantedSize);
        } else {
            LOG.info("Building all matchers for all possible fields.");
        }
        Map<String, MatcherConfig> matcherConfigs = this.config.getMatcherConfigs();
        this.userAgentMaxLength = this.config.getUserAgentMaxLength();
        if (matcherConfigs.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
        this.allMatchers.clear();
        for (Map.Entry<String, MatcherConfig> matcherConfigEntry : matcherConfigs.entrySet()) {
            MatcherConfig matcherConfig = matcherConfigEntry.getValue();
            try {
                this.allMatchers.add(new Matcher(this, this.wantedFieldNames, matcherConfig));
            }
            catch (UselessMatcherException uselessMatcherException) {}
        }
        this.verifyWeAreNotAskingForImpossibleFields();
        if (!this.delayInitialization) {
            this.initializeMatchers();
        }
    }

    private void verifyWeAreNotAskingForImpossibleFields() {
        if (this.wantedFieldNames == null) {
            return;
        }
        ArrayList<String> impossibleFields = new ArrayList<String>();
        List<String> allPossibleFields = this.getAllPossibleFieldNamesSorted();
        for (String wantedFieldName : this.wantedFieldNames) {
            if (UserAgent.MutableUserAgent.isSystemField(wantedFieldName) || allPossibleFields.contains(wantedFieldName)) continue;
            impossibleFields.add(wantedFieldName);
        }
        if (impossibleFields.isEmpty()) {
            return;
        }
        throw new InvalidParserConfigurationException("We cannot provide these fields:" + String.valueOf(impossibleFields));
    }

    public synchronized void initializeMatchers() {
        if (this.matchersHaveBeenInitialized) {
            return;
        }
        LOG.info("Initializing Analyzer data structures");
        if (this.allMatchers.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
        long start = System.nanoTime();
        this.allMatchers.forEach(Matcher::initialize);
        long stop = System.nanoTime();
        this.matchersHaveBeenInitialized = true;
        LOG.info("Built in {} msec : Hashmap {}, Ranges map:{}", (Object)((stop - start) / 1000000L), (Object)this.informMatcherActions.size(), (Object)this.informMatcherActionRanges.size());
        for (Matcher matcher : this.allMatchers) {
            if (matcher.getActionsThatRequireInput() != 0L) continue;
            this.zeroInputMatchers.add(matcher);
        }
        for (Matcher matcher : this.allMatchers) {
            matcher.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllPossibleFieldNames() {
        if (this.allPossibleFieldNamesCache == null) {
            UserAgentStringMatchMaker userAgentStringMatchMaker = this;
            synchronized (userAgentStringMatchMaker) {
                if (this.allPossibleFieldNamesCache == null) {
                    TreeSet<String> names = new TreeSet<String>(CORE_SYSTEM_GENERATED_FIELDS);
                    if (this.wantedFieldNames == null) {
                        for (Matcher matcher : this.allMatchers) {
                            names.addAll(matcher.getAllPossibleFieldNames());
                        }
                        for (FieldCalculator calculator : this.fieldCalculators) {
                            names.add(calculator.getCalculatedFieldName());
                        }
                    } else {
                        for (Matcher matcher : this.allMatchers) {
                            for (String possibleFieldName : matcher.getAllPossibleFieldNames()) {
                                if (!this.wantedFieldNames.contains(possibleFieldName)) continue;
                                names.add(possibleFieldName);
                            }
                        }
                        for (FieldCalculator calculator : this.fieldCalculators) {
                            String possibleFieldName = calculator.getCalculatedFieldName();
                            if (!this.wantedFieldNames.contains(possibleFieldName)) continue;
                            names.add(possibleFieldName);
                        }
                        names.remove("__Set_ALL_Fields__");
                    }
                    this.allPossibleFieldNamesCache = names;
                }
            }
        }
        return this.allPossibleFieldNamesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllPossibleFieldNamesSorted() {
        if (this.allPossibleFieldNamesSortedCache == null) {
            UserAgentStringMatchMaker userAgentStringMatchMaker = this;
            synchronized (userAgentStringMatchMaker) {
                if (this.allPossibleFieldNamesSortedCache == null) {
                    ArrayList<String> fieldNames = new ArrayList<String>(this.getAllPossibleFieldNames());
                    Collections.sort(fieldNames);
                    ArrayList<String> names = new ArrayList<String>();
                    for (String fieldName : UserAgent.PRE_SORTED_FIELDS_LIST) {
                        fieldNames.remove(fieldName);
                        names.add(fieldName);
                    }
                    names.addAll(fieldNames);
                    names.remove("__SyntaxError__");
                    names.add("__SyntaxError__");
                    this.allPossibleFieldNamesSortedCache = names;
                }
            }
        }
        return this.allPossibleFieldNamesSortedCache;
    }

    @Override
    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        Set ranges = this.informMatcherActionRanges.computeIfAbsent(treeName, k -> new LinkedHashSet(4));
        ranges.add(range);
    }

    public static int firstCharactersForPrefixHashLength(String input, int maxChars) {
        return Math.min(maxChars, Math.min(3, input.length()));
    }

    public static String firstCharactersForPrefixHash(String input, int maxChars) {
        return input.substring(0, UserAgentStringMatchMaker.firstCharactersForPrefixHashLength(input, maxChars));
    }

    @Override
    public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        this.informMeAbout(matcherAction, treeName + "{\"" + UserAgentStringMatchMaker.firstCharactersForPrefixHash(prefix, 3) + "\"");
        Set lengths = this.informMatcherActionPrefixesLengths.computeIfAbsent(treeName, k -> new LinkedHashSet(4));
        lengths.add(UserAgentStringMatchMaker.firstCharactersForPrefixHashLength(prefix, 3));
    }

    @Override
    public Set<Integer> getRequiredPrefixLengths(String treeName) {
        return this.informMatcherActionPrefixesLengths.get(treeName);
    }

    @Override
    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        String hashKey = keyPattern.toLowerCase(Locale.ROOT);
        Set analyzerSet = this.informMatcherActions.computeIfAbsent(hashKey, k -> new LinkedHashSet());
        analyzerSet.add(matcherAction);
    }

    public synchronized void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
        this.flattener.setVerbose(newVerbose);
    }

    @Override
    public int getUserAgentMaxLength() {
        return this.userAgentMaxLength;
    }

    private void setAsHacker(UserAgent.MutableUserAgent userAgent, int confidence) {
        userAgent.set("DeviceClass", "Hacker", confidence);
        userAgent.set("DeviceBrand", "Hacker", confidence);
        userAgent.set("DeviceName", "Hacker", confidence);
        userAgent.set("DeviceVersion", "Hacker", confidence);
        userAgent.set("OperatingSystemClass", "Hacker", confidence);
        userAgent.set("OperatingSystemName", "Hacker", confidence);
        userAgent.set("OperatingSystemVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineClass", "Hacker", confidence);
        userAgent.set("LayoutEngineName", "Hacker", confidence);
        userAgent.set("LayoutEngineVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineVersionMajor", "Hacker", confidence);
        userAgent.set("AgentClass", "Hacker", confidence);
        userAgent.set("AgentName", "Hacker", confidence);
        userAgent.set("AgentVersion", "Hacker", confidence);
        userAgent.set("AgentVersionMajor", "Hacker", confidence);
        userAgent.set("HackerToolkit", "Unknown", confidence);
        userAgent.set("HackerAttackVector", "Unknown", confidence);
        userAgent.set("RemarkablePattern", "Hacker", confidence);
    }

    @Override
    public void receivedInput(Matcher matcher) {
        if (this.zeroInputMatchers.contains(matcher)) {
            return;
        }
        this.touchedMatchers.add(matcher);
    }

    public synchronized void reset() {
        for (Matcher matcher : this.touchedMatchers) {
            matcher.reset();
        }
        this.touchedMatchers.clear();
        for (Matcher matcher : this.zeroInputMatchers) {
            matcher.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public UserAgent.MutableUserAgent parse(UserAgent.MutableUserAgent userAgent) {
        this.initializeMatchers();
        String useragentString = userAgent.getUserAgentString();
        if (useragentString != null && useragentString.length() > this.userAgentMaxLength) {
            this.setAsHacker(userAgent, 100);
            userAgent.setForced("HackerAttackVector", "Buffer overflow", 100L);
            return userAgent;
        }
        UserAgentStringMatchMaker userAgentStringMatchMaker = this;
        synchronized (userAgentStringMatchMaker) {
            this.reset();
            if (userAgent.isDebug()) {
                for (Matcher matcher : this.allMatchers) {
                    matcher.setVerboseTemporarily(true);
                }
            }
            try {
                userAgent = this.flattener.parse(userAgent);
                this.inform("__SyntaxError__", userAgent.getValue("__SyntaxError__"), null);
                if (this.verbose) {
                    LOG.info("=========== Checking all Touched Matchers: {}", (Object)this.touchedMatchers.size());
                }
                for (Matcher matcher : this.touchedMatchers) {
                    matcher.analyze(userAgent);
                }
                if (this.verbose) {
                    LOG.info("=========== Checking all Zero Input Matchers: {}", (Object)this.zeroInputMatchers.size());
                }
                for (Matcher matcher : this.zeroInputMatchers) {
                    matcher.analyze(userAgent);
                }
                userAgent.processSetAll();
            }
            catch (RuntimeException rte) {
                userAgent.reset();
                this.setAsHacker(userAgent, 10000);
                userAgent.setForced("HackerAttackVector", "Yauaa Exploit", 10000L);
            }
        }
        return userAgent;
    }

    public boolean isWantedField(String fieldName) {
        if (this.wantedFieldNames == null) {
            return true;
        }
        return this.wantedFieldNames.contains(fieldName);
    }

    public Set<String> getWantedFieldNames() {
        return this.wantedFieldNames;
    }

    public void setFieldCalculators(List<FieldCalculator> newFieldCalculators) {
        this.fieldCalculators.addAll(newFieldCalculators);
    }

    public UserAgent.MutableUserAgent hardCodedPostProcessing(UserAgent.MutableUserAgent userAgent) {
        if ("true".equals(userAgent.getValue("__SyntaxError__")) && userAgent.get("DeviceClass").getConfidence() == -1L) {
            this.setAsHacker(userAgent, 10);
        }
        for (FieldCalculator fieldCalculator : this.fieldCalculators) {
            if (this.verbose) {
                LOG.info("Running FieldCalculator: {}", (Object)fieldCalculator);
            }
            fieldCalculator.calculate(userAgent);
        }
        return userAgent;
    }

    @Override
    public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
        return this.informMatcherActionRanges.computeIfAbsent(treeName, k -> Collections.emptySet());
    }

    @Override
    public void inform(String key, String value, ParseTree ctx) {
        this.inform(key, key, value, ctx);
        this.inform(key + "=\"" + value + "\"", key, value, ctx);
        Set<Integer> lengths = this.getRequiredPrefixLengths(key);
        if (lengths != null) {
            int valueLength = value.length();
            for (Integer prefixLength : lengths) {
                if (valueLength < prefixLength) continue;
                this.inform(key + "{\"" + UserAgentStringMatchMaker.firstCharactersForPrefixHash(value, prefixLength) + "\"", key, value, ctx);
            }
        }
    }

    private void inform(String match, String key, String value, ParseTree ctx) {
        Set<MatcherAction> relevantActions = this.informMatcherActions.get(match.toLowerCase(Locale.ROOT));
        if (this.verbose) {
            if (relevantActions == null) {
                LOG.info("--- Have (0): {}", (Object)match);
            } else {
                LOG.info("+++ Have ({}): {}", (Object)relevantActions.size(), (Object)match);
                int count = 1;
                for (MatcherAction action : relevantActions) {
                    LOG.info("+++ -------> ({}): {}", (Object)count, (Object)action);
                    ++count;
                }
            }
        }
        if (relevantActions != null) {
            for (MatcherAction matcherAction : relevantActions) {
                matcherAction.inform(key, value, ctx);
            }
        }
    }

    public UserAgentStringMatchMaker(AnalyzerConfig analyzerConfig, boolean showMatcherStats, boolean delayInitialization) {
        this.config = analyzerConfig;
        this.showMatcherStats = showMatcherStats;
        this.delayInitialization = delayInitialization;
        Set<String> newWantedFieldNames = this.config.getWantedFieldNames();
        if (newWantedFieldNames != null && !newWantedFieldNames.isEmpty()) {
            this.wantedFieldNames = new TreeSet<String>(newWantedFieldNames);
        }
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("AgentNameVersionMajor", "AgentName", "AgentVersionMajor"));
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("AgentNameVersion", "AgentName", "AgentVersion"));
        this.registerFieldCalculator(new MajorVersionCalculator("AgentVersionMajor", "AgentVersion"));
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor"));
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("WebviewAppNameVersion", "WebviewAppName", "WebviewAppVersion"));
        this.registerFieldCalculator(new MajorVersionCalculator("WebviewAppVersionMajor", "WebviewAppVersion"));
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor"));
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion"));
        this.registerFieldCalculator(new MajorVersionCalculator("LayoutEngineVersionMajor", "LayoutEngineVersion"));
        this.registerFieldCalculator(new MajorVersionCalculator("OperatingSystemNameVersionMajor", "OperatingSystemNameVersion"));
        this.registerFieldCalculator(new MacOSXMajorVersionCalculator("OperatingSystemNameVersionMajor", "OperatingSystemNameVersion"));
        this.registerFieldCalculator(new ConcatNONDuplicatedCalculator("OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion"));
        this.registerFieldCalculator(new MajorVersionCalculator("OperatingSystemVersionMajor", "OperatingSystemVersion"));
        this.registerFieldCalculator(new MacOSXMajorVersionCalculator("OperatingSystemVersionMajor", "OperatingSystemVersion"));
        this.registerFieldCalculator(new CalculateAgentClass());
        this.registerFieldCalculator(new CalculateAgentName());
        this.registerFieldCalculator(new CalculateNetworkType());
        this.registerFieldCalculator(new CalculateDeviceName());
        this.registerFieldCalculator(new CalculateDeviceBrand(this));
        this.registerFieldCalculator(new CalculateAgentEmail());
        this.registerFieldCalculator(new VersionCleanupCalculator("AgentVersion"));
        this.registerFieldCalculator(new VersionCleanupCalculator("LayoutEngineVersion"));
        Collections.reverse(this.fieldCalculators);
        this.verifyCalculatorDependencyOrdering();
        if (this.wantedFieldNames != null && !this.wantedFieldNames.isEmpty()) {
            this.wantedFieldNames.addAll(ClientHintsAnalyzer.extraDependenciesNeededByClientCalculator(this.wantedFieldNames));
            this.wantedFieldNames.addAll(this.dependenciesNeededByCalculators);
            if (this.wantedFieldNames.contains("DeviceBrand") || this.wantedFieldNames.contains("DeviceName")) {
                this.wantedFieldNames.add("DeviceBrand");
                this.wantedFieldNames.add("DeviceName");
            }
        }
        this.finalizeLoadingRules();
    }

    private void registerFieldCalculator(FieldCalculator fieldCalculator) {
        String calculatedFieldName = fieldCalculator.getCalculatedFieldName();
        this.allFieldsForWhichACalculatorExists.add(calculatedFieldName);
        if (this.isWantedField(calculatedFieldName) || this.dependenciesNeededByCalculators.contains(calculatedFieldName)) {
            this.fieldCalculators.add(fieldCalculator);
            this.dependenciesNeededByCalculators.addAll(fieldCalculator.getDependencies());
        }
    }

    protected void verifyCalculatorDependencyOrdering() {
        HashSet<String> seenCalculatedFields = new HashSet<String>();
        for (FieldCalculator fieldCalculator : this.fieldCalculators) {
            for (String dependency : fieldCalculator.getDependencies()) {
                if (!this.allFieldsForWhichACalculatorExists.contains(dependency) || seenCalculatedFields.contains(dependency)) continue;
                throw new InvalidParserConfigurationException("Calculator ordering is wrong:For " + fieldCalculator.getCalculatedFieldName() + " we need " + dependency + " which is a calculated field but it has not yet been calculated.");
            }
            seenCalculatedFields.add(fieldCalculator.getCalculatedFieldName());
        }
    }

    public List<MatchesList.Match> getMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (Matcher matcher : this.getAllMatchers()) {
            allMatches.addAll(matcher.getMatches());
        }
        return allMatches;
    }

    public synchronized List<MatchesList.Match> getUsedMatches(UserAgent.MutableUserAgent userAgent) {
        for (Matcher matcher : this.getAllMatchers()) {
            matcher.reset();
            matcher.setVerboseTemporarily(false);
        }
        this.flattener.parse(userAgent);
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (Matcher matcher : this.getAllMatchers()) {
            allMatches.addAll(matcher.getUsedMatches());
        }
        return allMatches;
    }

    public String toString() {
        return "UserAgentStringMatchMaker{\n, showMatcherStats=" + this.showMatcherStats + "\n, wantedFieldNames=" + String.valueOf(this.wantedFieldNames) + "\n, userAgentMaxLength=" + this.userAgentMaxLength + "\n, delayInitialization=" + this.delayInitialization + "\n, matchersHaveBeenInitialized=" + this.matchersHaveBeenInitialized + "\n, verbose=" + this.verbose + "\n}";
    }

    static {
        CORE_SYSTEM_GENERATED_FIELDS.add("__SyntaxError__");
    }

    public static class KryoSerializer
    extends FieldSerializer<UserAgentStringMatchMaker> {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }

        public void write(Kryo kryo, Output output, UserAgentStringMatchMaker object) {
            object.reset();
            super.write(kryo, output, (Object)object);
        }

        public UserAgentStringMatchMaker read(Kryo kryo, Input input, Class<? extends UserAgentStringMatchMaker> type) {
            UserAgentStringMatchMaker uaa = (UserAgentStringMatchMaker)super.read(kryo, input, type);
            uaa.initTransientFields();
            uaa.showDeserializationStats();
            return uaa;
        }
    }
}

