/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints;

import com.esotericsoftware.kryo.Kryo;
import java.io.Serializable;
import java.util.ArrayList;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.StringPrefixMap;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.classify.DeviceClass;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.ClientHintsHeadersParser;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import nl.basjes.parse.useragent.utils.WordSplitter;

public class ClientHintsAnalyzer
extends ClientHintsHeadersParser {
    private static final PrefixMap<OSFields> WINDOWS_VERSION_MAPPING = new StringPrefixMap(false);

    public static void configureKryo(Object kryoInstance) {
        Kryo kryo = (Kryo)kryoInstance;
        kryo.register(ClientHintsAnalyzer.class);
        ClientHintsHeadersParser.configureKryo(kryoInstance);
    }

    public UserAgent.MutableUserAgent merge(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        this.setCHBrandVersionsList(userAgent, "UAClientHintBrands", clientHints.getBrands());
        this.setCHString(userAgent, "UAClientHintArchitecture", clientHints.getArchitecture());
        this.setCHString(userAgent, "UAClientHintBitness", clientHints.getBitness());
        this.setCHString(userAgent, "UAClientHintFullVersion", clientHints.getFullVersion());
        this.setCHBrandVersionsList(userAgent, "UAClientHintFullVersionList", clientHints.getFullVersionList());
        this.setCHBoolean(userAgent, "UAClientHintMobile", clientHints.getMobile());
        this.setCHString(userAgent, "UAClientHintModel", clientHints.getModel());
        this.setCHString(userAgent, "UAClientHintPlatform", clientHints.getPlatform());
        this.setCHString(userAgent, "UAClientHintPlatformVersion", clientHints.getPlatformVersion());
        this.setCHBoolean(userAgent, "UAClientHintWow64", clientHints.getWow64());
        this.improveMobileDeviceClass(userAgent, clientHints);
        this.improveDeviceBrandName(userAgent, clientHints);
        this.improveOperatingSystem(userAgent, clientHints);
        this.improveLayoutEngineAndAgentInfo(userAgent, clientHints);
        return userAgent;
    }

    private void setCHBrandVersionsList(UserAgent.MutableUserAgent userAgent, String baseFieldName, ArrayList<ClientHints.Brand> brands) {
        if (brands != null) {
            int i = 0;
            for (ClientHints.Brand brand : brands) {
                userAgent.set(baseFieldName + '_' + i + "_Brand", brand.getName(), 1L);
                userAgent.set(baseFieldName + '_' + i + "_Version", brand.getVersion(), 1L);
                ++i;
            }
        }
    }

    private void setCHString(UserAgent.MutableUserAgent userAgent, String fieldName, String value) {
        if (value != null) {
            userAgent.set(fieldName, value, 1L);
        }
    }

    private void setCHBoolean(UserAgent.MutableUserAgent userAgent, String fieldName, Boolean value) {
        if (value != null) {
            userAgent.set(fieldName, Boolean.TRUE.equals(value) ? "true" : "false", 1L);
        }
    }

    public void improveMobileDeviceClass(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        if (clientHints.getMobile() != null) {
            AgentField.MutableAgentField deviceClass = userAgent.get("DeviceClass");
            if (DeviceClass.MOBILE.getValue().equals(deviceClass.getValue())) {
                if (Boolean.TRUE.equals(clientHints.getMobile())) {
                    deviceClass.setValue(DeviceClass.PHONE.getValue(), deviceClass.getConfidence() + 1L);
                } else {
                    deviceClass.setValue(DeviceClass.TABLET.getValue(), deviceClass.getConfidence() + 1L);
                }
            }
        }
    }

    public void improveDeviceBrandName(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        if (clientHints.getModel() != null) {
            AgentField.MutableAgentField deviceBrand = userAgent.get("DeviceBrand");
            AgentField.MutableAgentField deviceName = userAgent.get("DeviceName");
            if ("Unknown".equals(deviceBrand.getValue()) || "Unknown".equals(deviceName.getValue())) {
                this.overrideValue(deviceBrand, WordSplitter.getInstance().getSingleSplit(clientHints.getModel(), 1));
                this.overrideValue(deviceName, clientHints.getModel());
            }
        }
    }

    public void improveOperatingSystem(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        String platform = clientHints.getPlatform();
        String platformVersion = clientHints.getPlatformVersion();
        if (platform != null && platformVersion != null && !platform.trim().isEmpty() && !platformVersion.trim().isEmpty()) {
            String majorVersion = VersionSplitter.getInstance().getSingleSplit(platformVersion, 1);
            switch (platform) {
                case "macOS": {
                    platform = "Mac OS";
                    this.overrideValue(userAgent.get("OperatingSystemName"), platform);
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), platform + " " + platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), platform + " " + majorVersion);
                    break;
                }
                case "Android": 
                case "Chrome OS": 
                case "iOS": 
                case "Linux": {
                    this.overrideValue(userAgent.get("OperatingSystemName"), platform);
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), platform + " " + platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), platform + " " + majorVersion);
                    break;
                }
                case "Windows": {
                    OSFields betterOsVersion = (OSFields)WINDOWS_VERSION_MAPPING.getLongestMatch(platformVersion);
                    if (betterOsVersion == null) break;
                    this.overrideValue(userAgent.get("OperatingSystemName"), betterOsVersion.getName());
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), betterOsVersion.getVersion());
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), betterOsVersion.getVersionMajor());
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), betterOsVersion.getNameVersion());
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), betterOsVersion.getNameVersionMajor());
                    break;
                }
                default: {
                    platform = userAgent.getValue("OperatingSystemName");
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), platform + " " + platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), platform + " " + majorVersion);
                }
            }
        }
    }

    public void improveLayoutEngineAndAgentInfo(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        ArrayList<ClientHints.Brand> fullVersionList = clientHints.getFullVersionList();
        if (fullVersionList != null && !fullVersionList.isEmpty()) {
            for (ClientHints.Brand brand : fullVersionList) {
                switch (brand.getName()) {
                    case "Chromium": {
                        String version = brand.getVersion();
                        String[] versionSplits = version.split("\\.");
                        if (versionSplits.length == 4 && !"0".equals(versionSplits[1])) break;
                        version = versionSplits[0] + '.' + versionSplits[1];
                        String majorVersion = versionSplits[0];
                        this.overrideValue(userAgent.get("LayoutEngineName"), "Blink");
                        this.overrideValue(userAgent.get("LayoutEngineVersion"), version);
                        this.overrideValue(userAgent.get("LayoutEngineNameVersion"), "Blink " + version);
                        this.overrideValue(userAgent.get("LayoutEngineVersionMajor"), majorVersion);
                        this.overrideValue(userAgent.get("LayoutEngineNameVersionMajor"), "Blink " + majorVersion);
                        if (fullVersionList.size() != 1) break;
                        String agentName = "Chromium";
                        version = brand.getVersion();
                        this.overrideValue(userAgent.get("AgentName"), agentName);
                        this.overrideValue(userAgent.get("AgentVersion"), version);
                        this.overrideValue(userAgent.get("AgentNameVersion"), agentName + " " + version);
                        this.overrideValue(userAgent.get("AgentVersionMajor"), majorVersion);
                        this.overrideValue(userAgent.get("AgentNameVersionMajor"), agentName + " " + majorVersion);
                        break;
                    }
                    case "Google Chrome": 
                    case "Chrome": {
                        String agentName = "Chrome";
                        String version = brand.getVersion();
                        String[] versionSplits = version.split("\\.");
                        if (versionSplits.length == 4 && !"0".equals(versionSplits[1])) break;
                        String majorVersion = versionSplits[0];
                        this.overrideValue(userAgent.get("AgentName"), agentName);
                        this.overrideValue(userAgent.get("AgentVersion"), version);
                        this.overrideValue(userAgent.get("AgentNameVersion"), agentName + " " + version);
                        this.overrideValue(userAgent.get("AgentVersionMajor"), majorVersion);
                        this.overrideValue(userAgent.get("AgentNameVersionMajor"), agentName + " " + majorVersion);
                        break;
                    }
                    case "Microsoft Edge": 
                    case "Edge": {
                        String agentName = "Edge";
                        String version = brand.getVersion();
                        String[] versionSplits = version.split("\\.");
                        if (versionSplits.length == 4 && !"0".equals(versionSplits[1])) break;
                        String majorVersion = versionSplits[0];
                        this.overrideValue(userAgent.get("AgentName"), agentName);
                        this.overrideValue(userAgent.get("AgentVersion"), version);
                        this.overrideValue(userAgent.get("AgentNameVersion"), agentName + " " + version);
                        this.overrideValue(userAgent.get("AgentVersionMajor"), majorVersion);
                        this.overrideValue(userAgent.get("AgentNameVersionMajor"), agentName + " " + majorVersion);
                        break;
                    }
                }
            }
        } else {
            ClientHints.Brand brand;
            ArrayList<ClientHints.Brand> brands = clientHints.getBrands();
            if (brands != null && brands.size() == 1 && "Chromium".equals((brand = brands.get(0)).getName())) {
                String version = brand.getVersion();
                this.overrideValue(userAgent.get("LayoutEngineName"), "Blink");
                this.overrideValue(userAgent.get("LayoutEngineVersion"), version);
                this.overrideValue(userAgent.get("LayoutEngineNameVersion"), "Blink " + version);
                this.overrideValue(userAgent.get("LayoutEngineVersionMajor"), version);
                this.overrideValue(userAgent.get("LayoutEngineNameVersionMajor"), "Blink " + version);
                this.overrideValue(userAgent.get("AgentName"), "Chromium");
                this.overrideValue(userAgent.get("AgentVersion"), version);
                this.overrideValue(userAgent.get("AgentNameVersion"), "Chromium " + version);
                this.overrideValue(userAgent.get("AgentVersionMajor"), version);
                this.overrideValue(userAgent.get("AgentNameVersionMajor"), "Chromium " + version);
            }
        }
    }

    private void overrideValue(AgentField.MutableAgentField field, String newValue) {
        field.setValue(newValue, field.getConfidence() + 1L);
    }

    static {
        WINDOWS_VERSION_MAPPING.put("0.1", (Serializable)new OSFields("Windows NT", "7", "7", "Windows 7", "Windows 7"));
        WINDOWS_VERSION_MAPPING.put("0.2", (Serializable)new OSFields("Windows NT", "8", "8", "Windows 8", "Windows 8"));
        WINDOWS_VERSION_MAPPING.put("0.3", (Serializable)new OSFields("Windows NT", "8.1", "8", "Windows 8.1", "Windows 8"));
        WINDOWS_VERSION_MAPPING.put("1", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("2", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("3", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("4", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("5", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("6", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("7", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("8", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("9", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("10", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("13", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("14", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("15", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("16", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
    }

    private static class OSFields
    implements Serializable {
        String name;
        String version;
        String versionMajor;
        String nameVersion;
        String nameVersionMajor;

        public OSFields(String name, String version, String versionMajor, String nameVersion, String nameVersionMajor) {
            this.name = name;
            this.version = version;
            this.versionMajor = versionMajor;
            this.nameVersion = nameVersion;
            this.nameVersionMajor = nameVersionMajor;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVersionMajor() {
            return this.versionMajor;
        }

        public String getNameVersion() {
            return this.nameVersion;
        }

        public String getNameVersionMajor() {
            return this.nameVersionMajor;
        }
    }
}

