/*
 * Yet Another UserAgent Analyzer
 * Copyright (C) 2013-2022 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.basjes.parse.useragent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PackagedRules {
    public static final List<String> RULE_FILES_LIST = Collections.unmodifiableList(Arrays.asList(
        "UserAgents/Additional-Tests.yaml",
 "UserAgents/Alcatel-Tests.yaml",
 "UserAgents/Amazon.yaml",
 "UserAgents/AmazonDevices.yaml",
 "UserAgents/Android.yaml",
 "UserAgents/AndroidDeviceOverrides.yaml",
 "UserAgents/Anonymized-Tests.yaml",
 "UserAgents/Anonymized.yaml",
 "UserAgents/Apple.yaml",
 "UserAgents/AppleTypes.yaml",
 "UserAgents/AppleTypesBasic.yaml",
 "UserAgents/AppleWebview.yaml",
 "UserAgents/Apps.yaml",
 "UserAgents/Asus-Tests.yaml",
 "UserAgents/Audio.yaml",
 "UserAgents/Bada.yaml",
 "UserAgents/BitWalker-tests.yaml",
 "UserAgents/BlackBerry.yaml",
 "UserAgents/BrokenUseragents-Tests.yaml",
 "UserAgents/BrokenUseragents.yaml",
 "UserAgents/CPUTypes.yaml",
 "UserAgents/Car.yaml",
 "UserAgents/ClientHints-Tests.yaml",
 "UserAgents/Cubot-Tests.yaml",
 "UserAgents/EMailClients.yaml",
 "UserAgents/Electron.yaml",
 "UserAgents/ExtendedAgents.yaml",
 "UserAgents/Facebook-OsMeta.yaml",
 "UserAgents/Facebook.yaml",
 "UserAgents/GameConsoles.yaml",
 "UserAgents/GeckoFirefox.yaml",
 "UserAgents/Gentoo.yaml",
 "UserAgents/GoannaPaleMoon.yaml",
 "UserAgents/GoogleChrome.yaml",
 "UserAgents/GoogleChrome70-Tests.yaml",
 "UserAgents/GoogleChromeFrozen.yaml",
 "UserAgents/GoogleFavicon-Tests.yaml",
 "UserAgents/GooglePixel.yaml",
 "UserAgents/Hackers-CodeInjection-Tests.yaml",
 "UserAgents/Hackers-Log4Shell-Tests.yaml",
 "UserAgents/Hackers-PathTraversal-Tests.yaml",
 "UserAgents/Hackers-Tests.yaml",
 "UserAgents/Hackers-Windows-NT-9.yaml",
 "UserAgents/Hackers.yaml",
 "UserAgents/HomeAppliances.yaml",
 "UserAgents/Huawei-Tests.yaml",
 "UserAgents/ISOLanguageCode-Tests.yaml",
 "UserAgents/ISOLanguageCode.yaml",
 "UserAgents/KaiOS.yaml",
 "UserAgents/Konqueror.yaml",
 "UserAgents/LG-Tests.yaml",
 "UserAgents/Lenovo-Tests.yaml",
 "UserAgents/Linux.yaml",
 "UserAgents/MSEdge.yaml",
 "UserAgents/MSInternetExplorer.yaml",
 "UserAgents/Mageia.yaml",
 "UserAgents/Maxthon.yaml",
 "UserAgents/Meizu-Tests.yaml",
 "UserAgents/Mobile.yaml",
 "UserAgents/MobileBrand-Tests.yaml",
 "UserAgents/MobileBrand-rules.yaml",
 "UserAgents/MobileBrands.yaml",
 "UserAgents/MobileBrowser-Tests.yaml",
 "UserAgents/Mozilla.yaml",
 "UserAgents/Nokia.yaml",
 "UserAgents/Openspc2-tests.yaml",
 "UserAgents/Opera.yaml",
 "UserAgents/OperatingSystem-Tests.yaml",
 "UserAgents/OperatingSystemDeviceNames.yaml",
 "UserAgents/Oppo-Tests.yaml",
 "UserAgents/OtherOS.yaml",
 "UserAgents/Otter-Tests.yaml",
 "UserAgents/Robot-Imitators.yaml",
 "UserAgents/RobotBaseRules.yaml",
 "UserAgents/Robots-Bing.yaml",
 "UserAgents/Robots-Google.yaml",
 "UserAgents/Robots-Libraries-Tests.yaml",
 "UserAgents/Robots-Null.yaml",
 "UserAgents/Robots-PriceSpiders.yaml",
 "UserAgents/Robots.yaml",
 "UserAgents/Safari.yaml",
 "UserAgents/Samsung.yaml",
 "UserAgents/SecurityFlag.yaml",
 "UserAgents/SettopBox.yaml",
 "UserAgents/Sony.yaml",
 "UserAgents/SpecialBrowsers.yaml",
 "UserAgents/TV.yaml",
 "UserAgents/Tencent.yaml",
 "UserAgents/URL.yaml",
 "UserAgents/UUID.yaml",
 "UserAgents/Ubuntu-18.10-Tests.yaml",
 "UserAgents/Ubuntu-Tests.yaml",
 "UserAgents/Ubuntu.yaml",
 "UserAgents/UbuntuVersionLookups.yaml",
 "UserAgents/VR.yaml",
 "UserAgents/ValidProductVersions-rules.yaml",
 "UserAgents/Vodafone-Tests.yaml",
 "UserAgents/Watches.yaml",
 "UserAgents/Wiko-Tests.yaml",
 "UserAgents/Windows.yaml",
 "UserAgents/WindowsCE.yaml",
 "UserAgents/WindowsDesktopLookups.yaml",
 "UserAgents/WindowsOEM-Tests.yaml",
 "UserAgents/WindowsOEMCodes.yaml",
 "UserAgents/WindowsPhone.yaml",
 "UserAgents/WindowsPhoneLookups.yaml",
 "UserAgents/Xiaomi.yaml",
 "UserAgents/eBook.yaml"
    ));

    public static List<String> getRuleFileNames() {
        return RULE_FILES_LIST;
    }
}
