/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUaFormFactor
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA-Form-Factor";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua-form-factor";
    public static final String HEADER_SPEC = "The Sec-CH-UA-Form-Factor request header field gives a server information about the user agent's form-factor.";
    public static final String FIELD_NAME = "secChUaFormFactor";

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        if (input == null) {
            return clientHints;
        }
        ArrayList<String> formFactors = this.parseSfList(input);
        if (!formFactors.isEmpty()) {
            clientHints.setFormFactors(formFactors);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }

    public static AbstractUserAgentAnalyzerDirect.HeaderSpecification getHeaderSpecification() {
        return new AbstractUserAgentAnalyzerDirect.HeaderSpecification(HEADER_FIELD, HEADER_SPEC_URL, HEADER_SPEC, FIELD_NAME);
    }
}

