/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.shaded.org.springframework.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import nl.basjes.shaded.org.springframework.core.MethodParameter;
import nl.basjes.shaded.org.springframework.core.ResolvableTypeProvider;
import nl.basjes.shaded.org.springframework.core.SerializableTypeWrapper;
import nl.basjes.shaded.org.springframework.util.Assert;
import nl.basjes.shaded.org.springframework.util.ClassUtils;
import nl.basjes.shaded.org.springframework.util.ConcurrentReferenceHashMap;
import nl.basjes.shaded.org.springframework.util.ObjectUtils;
import nl.basjes.shaded.org.springframework.util.StringUtils;

public class ResolvableType
implements Serializable {
    public static final ResolvableType NONE = new ResolvableType(null, null, null, 0);
    private static final ResolvableType[] EMPTY_TYPES_ARRAY = new ResolvableType[0];
    private static final ConcurrentReferenceHashMap<ResolvableType, ResolvableType> cache = new ConcurrentReferenceHashMap(256);
    private final Type type;
    private final SerializableTypeWrapper.TypeProvider typeProvider;
    private final VariableResolver variableResolver;
    private final ResolvableType componentType;
    private final Class<?> resolved;
    private final Integer hash;
    private ResolvableType superType;
    private ResolvableType[] interfaces;
    private ResolvableType[] generics;

    private ResolvableType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.resolved = null;
        this.hash = this.calculateHashCode();
    }

    private ResolvableType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver, Integer hash) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.resolved = this.resolveClass();
        this.hash = hash;
    }

    private ResolvableType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver, ResolvableType componentType) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = componentType;
        this.resolved = this.resolveClass();
        this.hash = null;
    }

    private ResolvableType(Class<?> clazz) {
        this.type = this.resolved = clazz != null ? clazz : Object.class;
        this.typeProvider = null;
        this.variableResolver = null;
        this.componentType = null;
        this.hash = null;
    }

    public Type getType() {
        return SerializableTypeWrapper.unwrap(this.type);
    }

    public Class<?> getRawClass() {
        if (this.type == this.resolved) {
            return this.resolved;
        }
        Type rawType = this.type;
        if (rawType instanceof ParameterizedType) {
            rawType = ((ParameterizedType)rawType).getRawType();
        }
        return rawType instanceof Class ? (Class)rawType : null;
    }

    public Object getSource() {
        Object source = this.typeProvider != null ? this.typeProvider.getSource() : null;
        return source != null ? source : this.type;
    }

    public boolean isInstance(Object obj) {
        return obj != null && this.isAssignableFrom(obj.getClass());
    }

    public boolean isAssignableFrom(Class<?> other) {
        return this.isAssignableFrom(ResolvableType.forClass(other), null);
    }

    public boolean isAssignableFrom(ResolvableType other) {
        return this.isAssignableFrom(other, null);
    }

    private boolean isAssignableFrom(ResolvableType other, Map<Type, Type> matchedBefore) {
        Assert.notNull(other, "ResolvableType must not be null");
        if (this == NONE || other == NONE) {
            return false;
        }
        if (this.isArray()) {
            return other.isArray() && this.getComponentType().isAssignableFrom(other.getComponentType());
        }
        if (matchedBefore != null && matchedBefore.get(this.type) == other.type) {
            return true;
        }
        WildcardBounds ourBounds = WildcardBounds.get(this);
        WildcardBounds typeBounds = WildcardBounds.get(other);
        if (typeBounds != null) {
            return ourBounds != null && ourBounds.isSameKind(typeBounds) && ourBounds.isAssignableFrom(typeBounds.getBounds());
        }
        if (ourBounds != null) {
            return ourBounds.isAssignableFrom(other);
        }
        boolean exactMatch = matchedBefore != null;
        boolean checkGenerics = true;
        Class<?> ourResolved = null;
        if (this.type instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)this.type;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
            }
            if (ourResolved == null && other.variableResolver != null && (resolved = other.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
                checkGenerics = false;
            }
            if (ourResolved == null) {
                exactMatch = false;
            }
        }
        if (ourResolved == null) {
            ourResolved = this.resolve(Object.class);
        }
        Class<?> otherResolved = other.resolve(Object.class);
        if (exactMatch ? !ourResolved.equals(otherResolved) : !ClassUtils.isAssignable(ourResolved, otherResolved)) {
            return false;
        }
        if (checkGenerics) {
            ResolvableType[] typeGenerics;
            ResolvableType[] ourGenerics = this.getGenerics();
            if (ourGenerics.length != (typeGenerics = other.as(ourResolved).getGenerics()).length) {
                return false;
            }
            if (matchedBefore == null) {
                matchedBefore = new IdentityHashMap<Type, Type>(1);
            }
            matchedBefore.put(this.type, other.type);
            for (int i = 0; i < ourGenerics.length; ++i) {
                if (ourGenerics[i].isAssignableFrom(typeGenerics[i], matchedBefore)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isArray() {
        if (this == NONE) {
            return false;
        }
        return this.type instanceof Class && ((Class)this.type).isArray() || this.type instanceof GenericArrayType || this.resolveType().isArray();
    }

    public ResolvableType getComponentType() {
        if (this == NONE) {
            return NONE;
        }
        if (this.componentType != null) {
            return this.componentType;
        }
        if (this.type instanceof Class) {
            Class<?> componentType = ((Class)this.type).getComponentType();
            return ResolvableType.forType(componentType, this.variableResolver);
        }
        if (this.type instanceof GenericArrayType) {
            return ResolvableType.forType(((GenericArrayType)this.type).getGenericComponentType(), this.variableResolver);
        }
        return this.resolveType().getComponentType();
    }

    public ResolvableType asCollection() {
        return this.as(Collection.class);
    }

    public ResolvableType asMap() {
        return this.as(Map.class);
    }

    public ResolvableType as(Class<?> type) {
        if (this == NONE) {
            return NONE;
        }
        if (ObjectUtils.nullSafeEquals(this.resolve(), type)) {
            return this;
        }
        for (ResolvableType interfaceType : this.getInterfaces()) {
            ResolvableType interfaceAsType = interfaceType.as(type);
            if (interfaceAsType == NONE) continue;
            return interfaceAsType;
        }
        return this.getSuperType().as(type);
    }

    public ResolvableType getSuperType() {
        Class<?> resolved = this.resolve();
        if (resolved == null || resolved.getGenericSuperclass() == null) {
            return NONE;
        }
        if (this.superType == null) {
            this.superType = ResolvableType.forType(SerializableTypeWrapper.forGenericSuperclass(resolved), this.asVariableResolver());
        }
        return this.superType;
    }

    public ResolvableType[] getInterfaces() {
        Class<?> resolved = this.resolve();
        if (resolved == null || ObjectUtils.isEmpty(resolved.getGenericInterfaces())) {
            return EMPTY_TYPES_ARRAY;
        }
        if (this.interfaces == null) {
            this.interfaces = ResolvableType.forTypes(SerializableTypeWrapper.forGenericInterfaces(resolved), this.asVariableResolver());
        }
        return this.interfaces;
    }

    public boolean hasGenerics() {
        return this.getGenerics().length > 0;
    }

    boolean isEntirelyUnresolvable() {
        ResolvableType[] generics;
        if (this == NONE) {
            return false;
        }
        for (ResolvableType generic : generics = this.getGenerics()) {
            if (generic.isUnresolvableTypeVariable() || generic.isWildcardWithoutBounds()) continue;
            return false;
        }
        return true;
    }

    public boolean hasUnresolvableGenerics() {
        ResolvableType[] generics;
        if (this == NONE) {
            return false;
        }
        for (ResolvableType generic : generics = this.getGenerics()) {
            if (!generic.isUnresolvableTypeVariable() && !generic.isWildcardWithoutBounds()) continue;
            return true;
        }
        Class<?> resolved = this.resolve();
        if (resolved != null) {
            for (Type genericInterface : resolved.getGenericInterfaces()) {
                if (!(genericInterface instanceof Class) || !ResolvableType.forClass((Class)genericInterface).hasGenerics()) continue;
                return true;
            }
            return this.getSuperType().hasUnresolvableGenerics();
        }
        return false;
    }

    private boolean isUnresolvableTypeVariable() {
        if (this.type instanceof TypeVariable) {
            if (this.variableResolver == null) {
                return true;
            }
            TypeVariable variable = (TypeVariable)this.type;
            ResolvableType resolved = this.variableResolver.resolveVariable(variable);
            if (resolved == null || resolved.isUnresolvableTypeVariable()) {
                return true;
            }
        }
        return false;
    }

    private boolean isWildcardWithoutBounds() {
        Type[] upperBounds;
        WildcardType wt;
        return this.type instanceof WildcardType && (wt = (WildcardType)this.type).getLowerBounds().length == 0 && ((upperBounds = wt.getUpperBounds()).length == 0 || upperBounds.length == 1 && Object.class == upperBounds[0]);
    }

    public ResolvableType getNested(int nestingLevel) {
        return this.getNested(nestingLevel, null);
    }

    public ResolvableType getNested(int nestingLevel, Map<Integer, Integer> typeIndexesPerLevel) {
        ResolvableType result = this;
        for (int i = 2; i <= nestingLevel; ++i) {
            if (result.isArray()) {
                result = result.getComponentType();
                continue;
            }
            while (result != NONE && !result.hasGenerics()) {
                result = result.getSuperType();
            }
            Integer index = typeIndexesPerLevel != null ? typeIndexesPerLevel.get(i) : null;
            index = index == null ? result.getGenerics().length - 1 : index;
            result = result.getGeneric(index);
        }
        return result;
    }

    public ResolvableType getGeneric(int ... indexes) {
        ResolvableType[] generics = this.getGenerics();
        if (indexes == null || indexes.length == 0) {
            return generics.length == 0 ? NONE : generics[0];
        }
        ResolvableType generic = this;
        for (int index : indexes) {
            generics = generic.getGenerics();
            if (index < 0 || index >= generics.length) {
                return NONE;
            }
            generic = generics[index];
        }
        return generic;
    }

    public ResolvableType[] getGenerics() {
        if (this == NONE) {
            return EMPTY_TYPES_ARRAY;
        }
        if (this.generics == null) {
            if (this.type instanceof Class) {
                Class typeClass = (Class)this.type;
                this.generics = ResolvableType.forTypes(SerializableTypeWrapper.forTypeParameters(typeClass), this.variableResolver);
            } else if (this.type instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)this.type).getActualTypeArguments();
                ResolvableType[] generics = new ResolvableType[actualTypeArguments.length];
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    generics[i] = ResolvableType.forType(actualTypeArguments[i], this.variableResolver);
                }
                this.generics = generics;
            } else {
                this.generics = this.resolveType().getGenerics();
            }
        }
        return this.generics;
    }

    public Class<?>[] resolveGenerics() {
        return this.resolveGenerics(null);
    }

    public Class<?>[] resolveGenerics(Class<?> fallback) {
        ResolvableType[] generics = this.getGenerics();
        Class[] resolvedGenerics = new Class[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            resolvedGenerics[i] = generics[i].resolve(fallback);
        }
        return resolvedGenerics;
    }

    public Class<?> resolveGeneric(int ... indexes) {
        return this.getGeneric(indexes).resolve();
    }

    public Class<?> resolve() {
        return this.resolve(null);
    }

    public Class<?> resolve(Class<?> fallback) {
        return this.resolved != null ? this.resolved : fallback;
    }

    private Class<?> resolveClass() {
        if (this.type instanceof Class || this.type == null) {
            return (Class)this.type;
        }
        if (this.type instanceof GenericArrayType) {
            Class<?> resolvedComponent = this.getComponentType().resolve();
            return resolvedComponent != null ? Array.newInstance(resolvedComponent, 0).getClass() : null;
        }
        return this.resolveType().resolve();
    }

    ResolvableType resolveType() {
        if (this.type instanceof ParameterizedType) {
            return ResolvableType.forType(((ParameterizedType)this.type).getRawType(), this.variableResolver);
        }
        if (this.type instanceof WildcardType) {
            Type resolved = this.resolveBounds(((WildcardType)this.type).getUpperBounds());
            if (resolved == null) {
                resolved = this.resolveBounds(((WildcardType)this.type).getLowerBounds());
            }
            return ResolvableType.forType(resolved, this.variableResolver);
        }
        if (this.type instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)this.type;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                return resolved;
            }
            return ResolvableType.forType(this.resolveBounds(variable.getBounds()), this.variableResolver);
        }
        return NONE;
    }

    private Type resolveBounds(Type[] bounds) {
        if (ObjectUtils.isEmpty(bounds) || Object.class == bounds[0]) {
            return null;
        }
        return bounds[0];
    }

    private ResolvableType resolveVariable(TypeVariable<?> variable) {
        if (this.type instanceof TypeVariable) {
            return this.resolveType().resolveVariable(variable);
        }
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            TypeVariable<Class<?>>[] variables = this.resolve().getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                if (!ObjectUtils.nullSafeEquals(variables[i].getName(), variable.getName())) continue;
                Type actualType = parameterizedType.getActualTypeArguments()[i];
                return ResolvableType.forType(actualType, this.variableResolver);
            }
            if (parameterizedType.getOwnerType() != null) {
                return ResolvableType.forType(parameterizedType.getOwnerType(), this.variableResolver).resolveVariable(variable);
            }
        }
        if (this.variableResolver != null) {
            return this.variableResolver.resolveVariable(variable);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvableType)) {
            return false;
        }
        ResolvableType otherType = (ResolvableType)other;
        if (!ObjectUtils.nullSafeEquals(this.type, otherType.type)) {
            return false;
        }
        if (!(this.typeProvider == otherType.typeProvider || this.typeProvider != null && otherType.typeProvider != null && ObjectUtils.nullSafeEquals(this.typeProvider.getType(), otherType.typeProvider.getType()))) {
            return false;
        }
        if (!(this.variableResolver == otherType.variableResolver || this.variableResolver != null && otherType.variableResolver != null && ObjectUtils.nullSafeEquals(this.variableResolver.getSource(), otherType.variableResolver.getSource()))) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.componentType, otherType.componentType);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.intValue() : this.calculateHashCode();
    }

    private int calculateHashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.type);
        if (this.typeProvider != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.typeProvider.getType());
        }
        if (this.variableResolver != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.variableResolver.getSource());
        }
        if (this.componentType != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.componentType);
        }
        return hashCode;
    }

    VariableResolver asVariableResolver() {
        if (this == NONE) {
            return null;
        }
        return new DefaultVariableResolver();
    }

    private Object readResolve() {
        return this.type == null ? NONE : this;
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType() + "[]";
        }
        if (this.resolved == null) {
            return "?";
        }
        if (this.type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)this.type;
            if (this.variableResolver == null || this.variableResolver.resolveVariable(variable) == null) {
                return "?";
            }
        }
        StringBuilder result = new StringBuilder(this.resolved.getName());
        if (this.hasGenerics()) {
            result.append('<');
            result.append(StringUtils.arrayToDelimitedString(this.getGenerics(), ", "));
            result.append('>');
        }
        return result.toString();
    }

    public static ResolvableType forClass(Class<?> clazz) {
        return new ResolvableType(clazz);
    }

    public static ResolvableType forRawClass(Class<?> clazz) {
        return new ResolvableType((Class)clazz){

            @Override
            public ResolvableType[] getGenerics() {
                return EMPTY_TYPES_ARRAY;
            }

            @Override
            public boolean isAssignableFrom(Class<?> other) {
                return ClassUtils.isAssignable(this.getRawClass(), other);
            }

            @Override
            public boolean isAssignableFrom(ResolvableType other) {
                Class<?> otherClass = other.getRawClass();
                return otherClass != null && ClassUtils.isAssignable(this.getRawClass(), otherClass);
            }
        };
    }

    public static ResolvableType forClass(Class<?> baseType, Class<?> implementationClass) {
        Assert.notNull(baseType, "Base type must not be null");
        ResolvableType asType = ResolvableType.forType(implementationClass).as(baseType);
        return asType == NONE ? ResolvableType.forType(baseType) : asType;
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, Class<?> ... generics) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(generics, "Generics array must not be null");
        ResolvableType[] resolvableGenerics = new ResolvableType[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            resolvableGenerics[i] = ResolvableType.forClass(generics[i]);
        }
        return ResolvableType.forClassWithGenerics(clazz, resolvableGenerics);
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, ResolvableType ... generics) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(generics, "Generics array must not be null");
        TypeVariable<Class<?>>[] variables = clazz.getTypeParameters();
        Assert.isTrue(variables.length == generics.length, "Mismatched number of generics specified");
        Type[] arguments = new Type[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            ResolvableType generic = generics[i];
            TypeVariable<Class<?>> argument = generic != null ? generic.getType() : null;
            arguments[i] = argument != null ? argument : variables[i];
        }
        SyntheticParameterizedType syntheticType = new SyntheticParameterizedType(clazz, arguments);
        return ResolvableType.forType((Type)syntheticType, new TypeVariablesVariableResolver(variables, generics));
    }

    public static ResolvableType forInstance(Object instance) {
        ResolvableType type;
        Assert.notNull(instance, "Instance must not be null");
        if (instance instanceof ResolvableTypeProvider && (type = ((ResolvableTypeProvider)instance).getResolvableType()) != null) {
            return type;
        }
        return ResolvableType.forClass(instance.getClass());
    }

    public static ResolvableType forField(Field field) {
        Assert.notNull(field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null);
    }

    public static ResolvableType forField(Field field, Class<?> implementationClass) {
        Assert.notNull(field, "Field must not be null");
        ResolvableType owner = ResolvableType.forType(implementationClass).as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner.asVariableResolver());
    }

    public static ResolvableType forField(Field field, ResolvableType implementationType) {
        Assert.notNull(field, "Field must not be null");
        ResolvableType owner = implementationType != null ? implementationType : NONE;
        owner = owner.as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner.asVariableResolver());
    }

    public static ResolvableType forField(Field field, int nestingLevel) {
        Assert.notNull(field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null).getNested(nestingLevel);
    }

    public static ResolvableType forField(Field field, int nestingLevel, Class<?> implementationClass) {
        Assert.notNull(field, "Field must not be null");
        ResolvableType owner = ResolvableType.forType(implementationClass).as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), owner.asVariableResolver()).getNested(nestingLevel);
    }

    public static ResolvableType forConstructorParameter(Constructor<?> constructor, int parameterIndex) {
        Assert.notNull(constructor, "Constructor must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(constructor, parameterIndex));
    }

    public static ResolvableType forConstructorParameter(Constructor<?> constructor, int parameterIndex, Class<?> implementationClass) {
        Assert.notNull(constructor, "Constructor must not be null");
        MethodParameter methodParameter = new MethodParameter(constructor, parameterIndex);
        methodParameter.setContainingClass(implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodReturnType(Method method) {
        Assert.notNull(method, "Method must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(method, -1));
    }

    public static ResolvableType forMethodReturnType(Method method, Class<?> implementationClass) {
        Assert.notNull(method, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter(method, -1);
        methodParameter.setContainingClass(implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(Method method, int parameterIndex) {
        Assert.notNull(method, "Method must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(method, parameterIndex));
    }

    public static ResolvableType forMethodParameter(Method method, int parameterIndex, Class<?> implementationClass) {
        Assert.notNull(method, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter(method, parameterIndex);
        methodParameter.setContainingClass(implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter) {
        return ResolvableType.forMethodParameter(methodParameter, (Type)null);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, ResolvableType implementationType) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        implementationType = implementationType != null ? implementationType : ResolvableType.forType(methodParameter.getContainingClass());
        ResolvableType owner = implementationType.as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner.asVariableResolver()).getNested(methodParameter.getNestingLevel(), methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, Type targetType) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        ResolvableType owner = ResolvableType.forType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(targetType, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner.asVariableResolver()).getNested(methodParameter.getNestingLevel(), methodParameter.typeIndexesPerLevel);
    }

    static void resolveMethodParameter(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        ResolvableType owner = ResolvableType.forType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        methodParameter.setParameterType(ResolvableType.forType(null, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner.asVariableResolver()).resolve());
    }

    public static ResolvableType forArrayComponent(ResolvableType componentType) {
        Assert.notNull(componentType, "Component type must not be null");
        Class<?> arrayClass = Array.newInstance(componentType.resolve(), 0).getClass();
        return new ResolvableType(arrayClass, null, null, componentType);
    }

    private static ResolvableType[] forTypes(Type[] types, VariableResolver owner) {
        ResolvableType[] result = new ResolvableType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = ResolvableType.forType(types[i], owner);
        }
        return result;
    }

    public static ResolvableType forType(Type type) {
        return ResolvableType.forType(type, null, null);
    }

    public static ResolvableType forType(Type type, ResolvableType owner) {
        VariableResolver variableResolver = null;
        if (owner != null) {
            variableResolver = owner.asVariableResolver();
        }
        return ResolvableType.forType(type, variableResolver);
    }

    static ResolvableType forType(Type type, VariableResolver variableResolver) {
        return ResolvableType.forType(type, null, variableResolver);
    }

    static ResolvableType forType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver) {
        if (type == null && typeProvider != null) {
            type = SerializableTypeWrapper.forTypeProvider(typeProvider);
        }
        if (type == null) {
            return NONE;
        }
        if (type instanceof Class) {
            return new ResolvableType(type, typeProvider, variableResolver, (ResolvableType)null);
        }
        cache.purgeUnreferencedEntries();
        ResolvableType key = new ResolvableType(type, typeProvider, variableResolver);
        ResolvableType resolvableType = cache.get(key);
        if (resolvableType == null) {
            resolvableType = new ResolvableType(type, typeProvider, variableResolver, key.hash);
            cache.put(resolvableType, resolvableType);
        }
        return resolvableType;
    }

    public static void clearCache() {
        cache.clear();
        SerializableTypeWrapper.cache.clear();
    }

    private static class WildcardBounds {
        private final Kind kind;
        private final ResolvableType[] bounds;

        public WildcardBounds(Kind kind, ResolvableType[] bounds) {
            this.kind = kind;
            this.bounds = bounds;
        }

        public boolean isSameKind(WildcardBounds bounds) {
            return this.kind == bounds.kind;
        }

        public boolean isAssignableFrom(ResolvableType ... types) {
            for (ResolvableType bound : this.bounds) {
                for (ResolvableType type : types) {
                    if (this.isAssignable(bound, type)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignable(ResolvableType source, ResolvableType from) {
            return this.kind == Kind.UPPER ? source.isAssignableFrom(from) : from.isAssignableFrom(source);
        }

        public ResolvableType[] getBounds() {
            return this.bounds;
        }

        public static WildcardBounds get(ResolvableType type) {
            ResolvableType resolveToWildcard = type;
            while (!(resolveToWildcard.getType() instanceof WildcardType)) {
                if (resolveToWildcard == NONE) {
                    return null;
                }
                resolveToWildcard = resolveToWildcard.resolveType();
            }
            WildcardType wildcardType = (WildcardType)resolveToWildcard.type;
            Kind boundsType = wildcardType.getLowerBounds().length > 0 ? Kind.LOWER : Kind.UPPER;
            Type[] bounds = boundsType == Kind.UPPER ? wildcardType.getUpperBounds() : wildcardType.getLowerBounds();
            ResolvableType[] resolvableBounds = new ResolvableType[bounds.length];
            for (int i = 0; i < bounds.length; ++i) {
                resolvableBounds[i] = ResolvableType.forType(bounds[i], type.variableResolver);
            }
            return new WildcardBounds(boundsType, resolvableBounds);
        }

        static enum Kind {
            UPPER,
            LOWER;

        }
    }

    private static final class SyntheticParameterizedType
    implements ParameterizedType,
    Serializable {
        private final Type rawType;
        private final Type[] typeArguments;

        public SyntheticParameterizedType(Type rawType, Type[] typeArguments) {
            this.rawType = rawType;
            this.typeArguments = typeArguments;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType otherType = (ParameterizedType)other;
            return otherType.getOwnerType() == null && this.rawType.equals(otherType.getRawType()) && Arrays.equals(this.typeArguments, otherType.getActualTypeArguments());
        }

        public int hashCode() {
            return this.rawType.hashCode() * 31 + Arrays.hashCode(this.typeArguments);
        }
    }

    private static class TypeVariablesVariableResolver
    implements VariableResolver {
        private final TypeVariable<?>[] variables;
        private final ResolvableType[] generics;

        public TypeVariablesVariableResolver(TypeVariable<?>[] variables, ResolvableType[] generics) {
            this.variables = variables;
            this.generics = generics;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            for (int i = 0; i < this.variables.length; ++i) {
                if (!SerializableTypeWrapper.unwrap(this.variables[i]).equals(SerializableTypeWrapper.unwrap(variable))) continue;
                return this.generics[i];
            }
            return null;
        }

        @Override
        public Object getSource() {
            return this.generics;
        }
    }

    private class DefaultVariableResolver
    implements VariableResolver {
        private DefaultVariableResolver() {
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            return ResolvableType.this.resolveVariable(variable);
        }

        @Override
        public Object getSource() {
            return ResolvableType.this;
        }
    }

    static interface VariableResolver
    extends Serializable {
        public Object getSource();

        public ResolvableType resolveVariable(TypeVariable<?> var1);
    }
}

