/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.walk.stepdown;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class ChildIterable {
    private boolean privateNumberRange = false;
    private final int start;
    private final int end;
    private final Predicate<ParserRuleContext> isWantedClassPredicate;

    public ChildIterable(boolean privateNumberRange, int start, int end, Predicate<ParserRuleContext> isWantedClassPredicate) {
        this.privateNumberRange = privateNumberRange;
        this.start = start;
        this.end = end;
        this.isWantedClassPredicate = isWantedClassPredicate;
    }

    public Iterator<ParserRuleContext> iterator(ParserRuleContext treeContext) {
        return new ChildIterator(treeContext);
    }

    class ChildIterator
    implements Iterator<ParserRuleContext> {
        private final Iterator<ParseTree> childIterator;
        private Boolean hasNext = null;
        private int index = 0;
        private ParserRuleContext nextChild;

        ChildIterator(ParserRuleContext treeContext) {
            this.childIterator = treeContext.children.iterator();
            this.hasNext = this.findNext();
        }

        private boolean findNext() {
            while (this.childIterator.hasNext()) {
                ParseTree nextParseTree = this.childIterator.next();
                if (Step.treeIsSeparator(nextParseTree) || !(nextParseTree instanceof ParserRuleContext)) continue;
                if (!ChildIterable.this.privateNumberRange) {
                    ++this.index;
                }
                ParserRuleContext possibleNextChild = (ParserRuleContext)nextParseTree;
                if (!ChildIterable.this.isWantedClassPredicate.test(possibleNextChild)) continue;
                if (ChildIterable.this.privateNumberRange) {
                    ++this.index;
                }
                if (this.index > ChildIterable.this.end) {
                    this.nextChild = null;
                    return false;
                }
                if (ChildIterable.this.start > this.index) continue;
                this.nextChild = possibleNextChild;
                return true;
            }
            this.nextChild = null;
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                this.hasNext = this.findNext();
            }
            return this.hasNext;
        }

        @Override
        public ParserRuleContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.nextChild;
        }
    }
}

