/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker;

import java.io.Serializable;
import java.util.Map;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeExpressionEvaluator
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TreeExpressionEvaluator.class);
    private boolean verbose = false;
    private final String requiredPatternText;
    private final Map<String, Map<String, String>> lookups;
    private final WalkList walkList;
    private final String fixedValue;

    public TreeExpressionEvaluator(ParserRuleContext requiredPattern, Map<String, Map<String, String>> lookups, boolean verbose) {
        this.requiredPatternText = requiredPattern.getText();
        this.lookups = lookups;
        this.verbose = verbose;
        this.walkList = new WalkList(requiredPattern, lookups, verbose);
        this.fixedValue = this.calculateFixedValue(requiredPattern);
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    private String calculateFixedValue(ParserRuleContext requiredPattern) {
        return (String)new UserAgentTreeWalkerBaseVisitor<String>(){

            @Override
            public String visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
                String value = (String)this.visit(ctx.matcher());
                if (value == null) {
                    return null;
                }
                Map lookup = (Map)TreeExpressionEvaluator.this.lookups.get(ctx.lookup.getText());
                if (lookup == null) {
                    throw new InvalidParserConfigurationException("Missing lookup \"" + ctx.lookup.getText() + "\" ");
                }
                String resultingValue = (String)lookup.get(value.toLowerCase());
                if (resultingValue == null) {
                    if (ctx.defaultValue != null) {
                        return ctx.defaultValue.getText();
                    }
                    throw new InvalidParserConfigurationException("Fixed value >>" + value + "<< is missing in lookup: \"" + ctx.lookup.getText() + "\" ");
                }
                return resultingValue;
            }

            @Override
            public String visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
                return ctx.value.getText();
            }
        }.visit(requiredPattern);
    }

    public String evaluate(ParseTree tree, String key, String value) {
        if (this.verbose) {
            LOG.info("Evaluate: {} => {}", (Object)key, (Object)value);
            LOG.info("Pattern : {}", (Object)this.requiredPatternText);
            LOG.info("WalkList: {}", (Object)this.walkList.toString());
        }
        String result = this.walkList.walk(tree, value);
        if (this.verbose) {
            LOG.info("Evaluate: Result = {}", (Object)result);
        }
        return result;
    }

    public boolean usesIsNull() {
        return this.walkList.usesIsNull();
    }

    public WalkList getWalkListForUnitTesting() {
        return this.walkList;
    }
}

