/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherRequireAction
extends MatcherAction {
    private static final Logger LOG = LoggerFactory.getLogger(MatcherRequireAction.class);
    private boolean foundRequiredValue = false;

    public MatcherRequireAction(String config, Matcher matcher) {
        this.init(config, matcher);
    }

    @Override
    protected ParserRuleContext parseWalkerExpression(UserAgentTreeWalkerParser parser) {
        return parser.matcherRequire();
    }

    @Override
    protected void setFixedValue(String fixedValue) {
        throw new InvalidParserConfigurationException("It is useless to put a fixed value \"" + fixedValue + "\" in the require section.");
    }

    @Override
    public void inform(String key, String foundValue) {
        this.foundRequiredValue = true;
        if (this.verbose) {
            LOG.info("Info REQUIRE: {}", (Object)key);
            LOG.info("NEED REQUIRE: {}", (Object)this.getMatchExpression());
            LOG.info("KEPT REQUIRE: {}", (Object)key);
        }
    }

    @Override
    public boolean obtainResult() {
        if (this.isValidIsNull()) {
            this.foundRequiredValue = true;
        }
        this.processInformedMatches();
        return this.foundRequiredValue;
    }

    @Override
    public void reset() {
        super.reset();
        this.foundRequiredValue = false;
    }

    public String toString() {
        return "Require: " + this.getMatchExpression();
    }
}

