/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.BitSet;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import nl.basjes.parse.useragent.analyze.NumberRangeVisitor;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.TreeExpressionEvaluator;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerLexer;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ANTLRErrorListener;
import nl.basjes.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonToken;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.shaded.org.antlr.v4.runtime.Parser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.shaded.org.antlr.v4.runtime.Token;
import nl.basjes.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import nl.basjes.shaded.org.antlr.v4.runtime.dfa.DFA;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatcherAction
implements Serializable {
    private String matchExpression;
    private TreeExpressionEvaluator evaluator;
    private static final Logger LOG = LoggerFactory.getLogger(MatcherAction.class);
    private Matcher matcher;
    private MatchesList matches;
    private boolean mustHaveMatches = false;
    boolean verbose = false;
    private boolean verbosePermanent = false;
    private boolean verboseTemporary = false;

    TreeExpressionEvaluator getEvaluatorForUnitTesting() {
        return this.evaluator;
    }

    boolean mustHaveMatches() {
        return this.mustHaveMatches;
    }

    private void setVerbose(boolean newVerbose) {
        this.setVerbose(newVerbose, false);
    }

    public void setVerbose(boolean newVerbose, boolean temporary) {
        this.verbose = newVerbose;
        if (!temporary) {
            this.verbosePermanent = newVerbose;
        }
        this.verboseTemporary = temporary;
    }

    public String getMatchExpression() {
        return this.matchExpression;
    }

    void init(String newMatchExpression, Matcher newMatcher) {
        this.matcher = newMatcher;
        this.matchExpression = newMatchExpression;
        this.setVerbose(newMatcher.getVerbose());
        InitErrorListener errorListener = new InitErrorListener();
        CodePointCharStream input = CharStreams.fromString(this.matchExpression);
        UserAgentTreeWalkerLexer lexer = new UserAgentTreeWalkerLexer(input);
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        UserAgentTreeWalkerParser parser = new UserAgentTreeWalkerParser(tokens);
        parser.addErrorListener(errorListener);
        ParserRuleContext requiredPattern = this.parseWalkerExpression(parser);
        if (requiredPattern == null) {
            throw new InvalidParserConfigurationException("NO pattern ?!?!?");
        }
        new UnQuoteValues().visit(requiredPattern);
        this.evaluator = new TreeExpressionEvaluator(requiredPattern, this.matcher.lookups, this.verbose);
        String fixedValue = this.evaluator.getFixedValue();
        if (fixedValue != null) {
            this.setFixedValue(fixedValue);
            this.mustHaveMatches = false;
            this.matches = new MatchesList(0);
            return;
        }
        this.mustHaveMatches = !this.evaluator.usesIsNull();
        int informs = this.calculateInformPath("agent", requiredPattern);
        int listSize = 0;
        if (informs > 0) {
            listSize = 1;
        }
        this.matches = new MatchesList(listSize);
    }

    protected abstract ParserRuleContext parseWalkerExpression(UserAgentTreeWalkerParser var1);

    protected abstract void setFixedValue(String var1);

    public void inform(String key, String value, ParseTree result) {
        if (this.mustHaveMatches && this.matches.isEmpty()) {
            this.matcher.gotMyFirstStartingPoint();
        }
        this.matches.add(key, value, result);
    }

    protected abstract void inform(String var1, String var2);

    boolean cannotBeValid() {
        return this.mustHaveMatches && this.matches.isEmpty();
    }

    public abstract boolean obtainResult();

    boolean isValidIsNull() {
        return this.matches.isEmpty() && this.evaluator.usesIsNull();
    }

    void processInformedMatches() {
        for (MatchesList.Match match : this.matches) {
            String matchedValue = this.evaluator.evaluate(match.result, match.key, match.value);
            if (matchedValue == null) continue;
            this.inform(match.key, matchedValue);
            break;
        }
    }

    private int calculateInformPath(String treeName, ParserRuleContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherRequireContext) {
            return this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.MatcherRequireContext)tree);
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherContext) {
            return this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.MatcherContext)tree);
        }
        return 0;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.MatcherRequireContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherBaseContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherBaseContext)tree).matcher());
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathIsNullContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherPathIsNullContext)tree).matcher());
        }
        return 0;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.MatcherContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherPathContext)tree).basePath());
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherCleanVersionContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherCleanVersionContext)tree).matcher());
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherNormalizeBrandContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherNormalizeBrandContext)tree).matcher());
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathLookupContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherPathLookupContext)tree).matcher());
        }
        if (tree instanceof UserAgentTreeWalkerParser.MatcherWordRangeContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.MatcherWordRangeContext)tree).matcher());
        }
        return 0;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.BasePathContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.PathWalkContext) {
            return this.calculateInformPath(treeName, ((UserAgentTreeWalkerParser.PathWalkContext)tree).nextStep);
        }
        return 0;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.PathContext tree) {
        if (tree != null) {
            if (tree instanceof UserAgentTreeWalkerParser.StepDownContext) {
                return this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.StepDownContext)tree);
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepEqualsValueContext) {
                return this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.StepEqualsValueContext)tree);
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepWordRangeContext) {
                return this.calculateInformPath(treeName, (UserAgentTreeWalkerParser.StepWordRangeContext)tree);
            }
        }
        this.matcher.informMeAbout(this, treeName);
        return 1;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.StepDownContext tree) {
        if (treeName.length() == 0) {
            return this.calculateInformPath(treeName + '.' + tree.name.getText(), tree.nextStep);
        }
        int informs = 0;
        for (Integer number : (NumberRangeList)NumberRangeVisitor.NUMBER_RANGE_VISITOR.visit(tree.numberRange())) {
            informs += this.calculateInformPath(treeName + '.' + "(" + number + ")" + tree.name.getText(), tree.nextStep);
        }
        return informs;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.StepEqualsValueContext tree) {
        this.matcher.informMeAbout(this, treeName + "=\"" + tree.value.getText() + "\"");
        return 1;
    }

    private int calculateInformPath(String treeName, UserAgentTreeWalkerParser.StepWordRangeContext tree) {
        WordRangeVisitor.Range range = WordRangeVisitor.getRange(tree.wordRange());
        this.matcher.lookingForRange(treeName, range);
        return this.calculateInformPath(treeName + "[" + range.first + "-" + range.last + "]", tree.nextStep);
    }

    public void reset() {
        this.matches.clear();
        if (this.verboseTemporary) {
            this.verbose = this.verbosePermanent;
        }
    }

    public MatchesList getMatches() {
        return this.matches;
    }

    private static class UnQuoteValues
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        private UnQuoteValues() {
        }

        private void unQuoteToken(Token token) {
            if (token instanceof CommonToken) {
                CommonToken commonToken = (CommonToken)token;
                commonToken.setStartIndex(commonToken.getStartIndex() + 1);
                commonToken.setStopIndex(commonToken.getStopIndex() - 1);
            }
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            this.unQuoteToken(ctx.defaultValue);
            return (Void)super.visitMatcherPathLookup(ctx);
        }

        @Override
        public Void visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitPathFixedValue(ctx);
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEqualsValue(ctx);
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepNotEqualsValue(ctx);
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepStartsWithValue(ctx);
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEndsWithValue(ctx);
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepContainsValue(ctx);
        }
    }

    class InitErrorListener
    implements ANTLRErrorListener {
        InitErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)MatcherAction.this.matchExpression);
            LOG.error("Message: {}", (Object)msg);
            throw new InvalidParserConfigurationException("Syntax error \"" + msg + "\" caused by \"" + MatcherAction.this.matchExpression + "\".");
        }

        @Override
        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        @Override
        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    }
}

