/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherExtractAction;
import nl.basjes.parse.useragent.analyze.MatcherRequireAction;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.utils.YamlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;

public class Matcher
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Matcher.class);
    private final Analyzer analyzer;
    private final List<MatcherAction> dynamicActions;
    private final List<MatcherAction> fixedStringActions;
    private UserAgent newValuesUserAgent = new UserAgent();
    private long actionsThatRequireInput;
    final Map<String, Map<String, String>> lookups;
    private boolean verbose;
    private boolean permanentVerbose;
    private String filename;
    private long actionsThatRequireInputAndReceivedInput = 0L;

    Matcher(Analyzer analyzer, Map<String, Map<String, String>> lookups) {
        this.lookups = lookups;
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    public Matcher(Analyzer analyzer, Map<String, Map<String, String>> lookups, List<String> wantedFieldNames, MappingNode matcherConfig, String filename) throws UselessMatcherException {
        this.lookups = lookups;
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
        this.filename = filename + ':' + matcherConfig.getStartMark().getLine();
        this.verbose = false;
        boolean hasActiveExtractConfigs = false;
        boolean hasDefinedExtractConfigs = false;
        ArrayList<ConfigLine> configLines = new ArrayList<ConfigLine>(16);
        block12: for (NodeTuple nodeTuple : matcherConfig.getValue()) {
            String name;
            switch (name = YamlUtils.getKeyAsString(nodeTuple, filename)) {
                case "options": {
                    List<String> options = YamlUtils.getStringValues(nodeTuple.getValueNode(), filename);
                    if (options == null) break;
                    this.verbose = options.contains("verbose");
                    break;
                }
                case "require": {
                    for (String requireConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), filename)) {
                        configLines.add(new ConfigLine(null, null, requireConfig));
                    }
                    continue block12;
                }
                case "extract": {
                    for (String extractConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), filename)) {
                        String[] configParts = extractConfig.split(":", 3);
                        if (configParts.length != 3) {
                            throw new InvalidParserConfigurationException("Invalid extract config line: " + extractConfig);
                        }
                        String attribute = configParts[0].trim();
                        Long confidence = Long.parseLong(configParts[1].trim());
                        String config = configParts[2].trim();
                        hasDefinedExtractConfigs = true;
                        if (wantedFieldNames == null || wantedFieldNames.contains(attribute)) {
                            configLines.add(new ConfigLine(attribute, confidence, config));
                            hasActiveExtractConfigs = true;
                            continue;
                        }
                        configLines.add(new ConfigLine(null, null, config));
                    }
                    continue block12;
                }
            }
        }
        this.permanentVerbose = this.verbose;
        if (this.verbose) {
            LOG.info("---------------------------");
            LOG.info("- MATCHER -");
        }
        if (!hasDefinedExtractConfigs) {
            throw new InvalidParserConfigurationException("Matcher does not extract anything");
        }
        if (!hasActiveExtractConfigs) {
            throw new UselessMatcherException("Does not extract any wanted fields");
        }
        for (ConfigLine configLine : configLines) {
            if (configLine.attribute == null) {
                if (this.verbose) {
                    LOG.info("REQUIRE: {}", (Object)configLine.expression);
                }
                try {
                    this.dynamicActions.add(new MatcherRequireAction(configLine.expression, this));
                    continue;
                }
                catch (InvalidParserConfigurationException e) {
                    if (e.getMessage().startsWith("It is useless to put a fixed value")) continue;
                    throw e;
                }
            }
            if (this.verbose) {
                LOG.info("EXTRACT: {}", (Object)configLine.expression);
            }
            MatcherExtractAction action = new MatcherExtractAction(configLine.attribute, configLine.confidence, configLine.expression, this);
            this.newValuesUserAgent.set(configLine.attribute, "Dummy", -9999L);
            action.setResultAgentField(this.newValuesUserAgent.get(configLine.attribute));
            if (action.isFixedValue()) {
                this.fixedStringActions.add(action);
                action.obtainResult();
                continue;
            }
            this.dynamicActions.add(action);
        }
        this.actionsThatRequireInput = 0L;
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
            if (!action.mustHaveMatches()) continue;
            ++this.actionsThatRequireInput;
        }
        if (this.verbose) {
            LOG.info("---------------------------");
        }
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(this.getAllPossibleFieldNames(this.dynamicActions));
        results.addAll(this.getAllPossibleFieldNames(this.fixedStringActions));
        results.remove("__Set_ALL_Fields__");
        return results;
    }

    private Set<String> getAllPossibleFieldNames(List<MatcherAction> actions) {
        TreeSet<String> results = new TreeSet<String>();
        for (MatcherAction action : actions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            MatcherExtractAction extractAction = (MatcherExtractAction)action;
            results.add(extractAction.getAttribute());
        }
        return results;
    }

    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        this.analyzer.lookingForRange(treeName, range);
    }

    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        this.analyzer.informMeAbout(matcherAction, keyPattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void analyze(UserAgent userAgent) {
        if (this.verbose) {
            LOG.info("");
            LOG.info("--- Matcher ------------------------");
            LOG.info("ANALYSE ----------------------------");
            boolean good = true;
            for (MatcherAction action : this.dynamicActions) {
                if (!action.cannotBeValid()) continue;
                LOG.error("CANNOT BE VALID : {}", (Object)action.getMatchExpression());
                good = false;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult()) continue;
                LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                good = false;
            }
            if (!good) {
                LOG.info("INCOMPLETE ----------------------------");
                return;
            }
            LOG.info("COMPLETE ----------------------------");
        } else {
            if (this.actionsThatRequireInput != this.actionsThatRequireInputAndReceivedInput) {
                return;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult()) continue;
                return;
            }
        }
        userAgent.set(this.newValuesUserAgent, this);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    void gotMyFirstStartingPoint() {
        ++this.actionsThatRequireInputAndReceivedInput;
    }

    public void setVerboseTemporarily(boolean newVerbose) {
        for (MatcherAction action : this.dynamicActions) {
            action.setVerbose(newVerbose, true);
        }
    }

    public void reset() {
        this.actionsThatRequireInputAndReceivedInput = 0L;
        this.verbose = this.permanentVerbose;
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
        }
    }

    public List<MatchesList.Match> getMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public List<MatchesList.Match> getUsedMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            if (!action.cannotBeValid()) continue;
            return new ArrayList<MatchesList.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (!action.obtainResult()) {
                return new ArrayList<MatchesList.Match>();
            }
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("MATCHER.(").append(this.filename).append("):\n");
        sb.append("    REQUIRE:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherRequireAction)) continue;
            sb.append("        ").append(action.getMatchExpression()).append("\n");
            sb.append("        ").append(action.getMatches().toStrings()).append("\n");
        }
        sb.append("    EXTRACT:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            sb.append("        ").append(action.toString()).append("\n");
            sb.append("        ").append(action.getMatches().toStrings()).append("\n");
        }
        for (MatcherAction action : this.fixedStringActions) {
            sb.append("        ").append(action.toString()).append("\n");
        }
        return sb.toString();
    }

    private static class ConfigLine {
        String attribute;
        Long confidence;
        String expression;

        ConfigLine(String attribute, Long confidence, String expression) {
            this.attribute = attribute;
            this.confidence = confidence;
            this.expression = expression;
        }
    }
}

