/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

public class Value {
    private final Filled filled;
    private String s = null;
    private Long l = null;
    private Double d = null;

    public Value(String p) {
        this.filled = Filled.STRING;
        this.s = p;
    }

    public Value(Long p) {
        this.filled = Filled.LONG;
        this.l = p;
    }

    public Value(Double p) {
        this.filled = Filled.DOUBLE;
        this.d = p;
    }

    public String getString() {
        switch (this.filled.ordinal()) {
            case 1: {
                return this.l == null ? null : Long.toString(this.l);
            }
            case 2: {
                return this.d == null ? null : Double.toString(this.d);
            }
        }
        return this.s;
    }

    public Long getLong() {
        switch (this.filled.ordinal()) {
            case 0: {
                try {
                    return this.s == null ? null : Long.valueOf(Long.parseLong(this.s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 2: {
                return this.d == null ? null : Long.valueOf((long)Math.floor(this.d + 0.5));
            }
        }
        return this.l;
    }

    public Double getDouble() {
        switch (this.filled.ordinal()) {
            case 0: {
                try {
                    return this.s == null ? null : Double.valueOf(Double.parseDouble(this.s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 1: {
                return this.l == null ? null : Double.valueOf(this.l.longValue());
            }
        }
        return this.d;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value{").append("filled=").append((Object)this.filled);
        if (this.s == null) {
            sb.append(", s=null");
        } else {
            sb.append(", s='").append(this.s).append('\'');
        }
        sb.append(", l=").append(this.l).append(", d=").append(this.d).append('}');
        return sb.toString();
    }

    static enum Filled {
        STRING,
        LONG,
        DOUBLE;

    }
}

