/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(Dissector.class);

    public abstract boolean initializeFromSettingsParameter(String var1);

    public abstract void dissect(Parsable<?> var1, String var2) throws DissectionFailure;

    public abstract String getInputType();

    public abstract List<String> getPossibleOutput();

    public abstract EnumSet<Casts> prepareForDissect(String var1, String var2);

    public abstract void prepareForRun() throws InvalidDissectorException;

    public Dissector getNewInstance() {
        try {
            Constructor<?> co = this.getClass().getConstructor(new Class[0]);
            Dissector newInstance = (Dissector)co.newInstance(new Object[0]);
            this.initializeNewInstance(newInstance);
            return newInstance;
        }
        catch (Exception e) {
            LOG.error("Unable to create instance of {}: {}", (Object)this.getClass().getCanonicalName(), (Object)e.toString());
            return null;
        }
    }

    public String extractFieldName(String inputname, String outputname) {
        String fieldName = outputname;
        if (inputname.equals(outputname)) {
            return "";
        }
        if (!inputname.equals("")) {
            fieldName = outputname.substring(inputname.length() + 1);
        }
        return fieldName;
    }

    protected abstract void initializeNewInstance(Dissector var1) throws InvalidDissectorException;

    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
    }

    public void setInputType(String s) throws InvalidDissectorException {
        throw new InvalidDissectorException("The InputType of " + this.getClass().getCanonicalName() + " cannot be changed");
    }

    public String toString() {
        return "{ " + this.getClass().getSimpleName() + " : " + this.getInputType() + " --> " + this.getPossibleOutput() + " }";
    }
}

